/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public abstract class BuildBloomBase<T>
extends EvalFunc<T> {
    protected int vSize;
    protected int numHash;
    protected int hType;
    protected BloomFilter filter;

    protected BuildBloomBase() {
    }

    public BuildBloomBase(String hashType, String mode, String vectorSize, String nbHash) {
        this.vSize = Integer.valueOf(vectorSize);
        this.numHash = Integer.valueOf(nbHash);
        this.hType = this.convertHashType(hashType);
    }

    public BuildBloomBase(String hashType, String numElements, String desiredFalsePositive) {
        this.setSize(numElements, desiredFalsePositive);
        this.hType = this.convertHashType(hashType);
    }

    protected DataByteArray bloomOr(Tuple input) throws IOException {
        this.filter = new BloomFilter(this.vSize, this.numHash, this.hType);
        try {
            DataBag values = (DataBag)input.get(0);
            for (Tuple t : values) {
                this.filter.or((Filter)this.bloomIn((DataByteArray)t.get(0)));
            }
        }
        catch (ExecException ee) {
            throw new IOException(ee);
        }
        return this.bloomOut();
    }

    protected DataByteArray bloomOut() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.vSize / 8);
        DataOutputStream dos = new DataOutputStream(baos);
        this.filter.write((DataOutput)dos);
        return new DataByteArray(baos.toByteArray());
    }

    protected BloomFilter bloomIn(DataByteArray b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b.get()));
        BloomFilter f = new BloomFilter();
        f.readFields((DataInput)dis);
        return f;
    }

    private int convertHashType(String hashType) {
        if (hashType.toLowerCase().contains("jenkins")) {
            return 0;
        }
        if (hashType.toLowerCase().contains("murmur")) {
            return 1;
        }
        throw new RuntimeException("Unknown hash type " + hashType + ".  Valid values are jenkins and murmur.");
    }

    private void setSize(String numElements, String desiredFalsePositive) {
        int num = Integer.valueOf(numElements);
        float fp = Float.valueOf(desiredFalsePositive).floatValue();
        if (num < 1 || (double)fp < 0.0 || (double)fp >= 1.0) {
            throw new RuntimeException("Number of elements must be greater than zero and desiredFalsePositive must be between 0  and 1.");
        }
        this.vSize = (int)(-1.0 * ((double)num * Math.log(fp)) / Math.pow(Math.log(2.0), 2.0));
        this.log.info((Object)("BuildBloom setting vector size to " + this.vSize));
        this.numHash = (int)(0.7 * (double)this.vSize / (double)num);
        this.log.info((Object)("BuildBloom setting number of hashes to " + this.numHash));
    }
}

