/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.KeyExtent;

public class MutationsRejectedException
extends AccumuloException {
    private static final long serialVersionUID = 1L;
    private List<ConstraintViolationSummary> cvsl;
    private Map<KeyExtent, Set<SecurityErrorCode>> af;
    private Collection<String> es;
    private int unknownErrors;

    public MutationsRejectedException(List<ConstraintViolationSummary> cvsList, HashMap<KeyExtent, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("# constraint violations : " + cvsList.size() + "  security codes: " + hashMap.values() + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl = cvsList;
        this.af = hashMap;
        this.es = serverSideErrors;
        this.unknownErrors = unknownErrors;
    }

    public List<ConstraintViolationSummary> getConstraintViolationSummaries() {
        return this.cvsl;
    }

    public List<KeyExtent> getAuthorizationFailures() {
        return new ArrayList<KeyExtent>(this.af.keySet());
    }

    public Map<KeyExtent, Set<SecurityErrorCode>> getAuthorizationFailuresMap() {
        return this.af;
    }

    public Collection<String> getErrorServers() {
        return this.es;
    }

    public int getUnknownExceptions() {
        return this.unknownErrors;
    }
}

