/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.admin.InstanceOperations;

class PingIterator
implements Iterator<String> {
    private Iterator<String> iter;
    private InstanceOperations instanceOps;

    PingIterator(List<String> tservers, InstanceOperations instanceOps) {
        this.iter = tservers.iterator();
        this.instanceOps = instanceOps;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public String next() {
        String tserver = this.iter.next();
        try {
            this.instanceOps.ping(tserver);
        }
        catch (AccumuloException e) {
            return tserver + " ERROR " + e.getMessage();
        }
        return tserver + " OK";
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

