/*
 * Decompiled with CFR 0.152.
 */
package tachyon.underfs.s3;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.conf.TachyonConf;
import tachyon.org.jets3t.service.ServiceException;
import tachyon.underfs.UnderFileSystem;
import tachyon.underfs.UnderFileSystemFactory;
import tachyon.underfs.s3.S3UnderFileSystem;

public class S3UnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    public UnderFileSystem create(String path, TachyonConf tachyonConf, Object unusedConf) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)tachyonConf);
        if (this.addAndCheckAWSCredentials(tachyonConf)) {
            TachyonURI uri = new TachyonURI(path);
            try {
                return new S3UnderFileSystem(uri.getHost(), tachyonConf);
            }
            catch (ServiceException se) {
                LOG.error("Failed to create S3UnderFileSystem.", (Throwable)se);
                throw Throwables.propagate((Throwable)se);
            }
        }
        String err = "AWS Credentials not available, cannot create S3 Under File System.";
        LOG.error(err);
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path, TachyonConf tachyonConf) {
        return path != null && path.startsWith("s3n://");
    }

    private boolean addAndCheckAWSCredentials(TachyonConf tachyonConf) {
        String secretKeyConf;
        String accessKeyConf = "fs.s3n.awsAccessKeyId";
        if (System.getProperty(accessKeyConf) != null && tachyonConf.get(accessKeyConf) == null) {
            tachyonConf.set(accessKeyConf, System.getProperty(accessKeyConf));
        }
        if (System.getProperty(secretKeyConf = "fs.s3n.awsSecretAccessKey") != null && tachyonConf.get(secretKeyConf) == null) {
            tachyonConf.set(secretKeyConf, System.getProperty(secretKeyConf));
        }
        return tachyonConf.get(accessKeyConf) != null && tachyonConf.get(secretKeyConf) != null;
    }
}

