/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.junit.Assume;
import org.junit.Test;

public class TestShell
extends TestCase {
    public void testInterval() throws IOException {
        this.testInterval(-153722867280912L);
        this.testInterval(0L);
        this.testInterval(10L);
        this.testInterval(Time.now() / 60000L + 60L);
    }

    private void assertInString(String string, String search) {
        TestShell.assertNotNull((String)"Empty String", (Object)string);
        if (!string.contains(search)) {
            TestShell.fail((String)("Did not find \"" + search + "\" in " + string));
        }
    }

    public void testShellCommandExecutorToString() throws Throwable {
        Shell.ShellCommandExecutor sce = new Shell.ShellCommandExecutor(new String[]{"ls", "..", "arg 2"});
        String command = sce.toString();
        this.assertInString(command, "ls");
        this.assertInString(command, " .. ");
        this.assertInString(command, "\"arg 2\"");
    }

    public void testShellCommandTimeout() throws Throwable {
        if (Shell.WINDOWS) {
            return;
        }
        String rootDir = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        File shellFile = new File(rootDir, "timeout.sh");
        String timeoutCommand = "sleep 4; echo \"hello\"";
        PrintWriter writer = new PrintWriter(new FileOutputStream(shellFile));
        writer.println(timeoutCommand);
        writer.close();
        FileUtil.setExecutable((File)shellFile, (boolean)true);
        Shell.ShellCommandExecutor shexc = new Shell.ShellCommandExecutor(new String[]{shellFile.getAbsolutePath()}, null, null, 100L);
        try {
            shexc.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        shellFile.delete();
        TestShell.assertTrue((String)"Script didnt not timeout", (boolean)shexc.isTimedOut());
    }

    @Test
    public void testEnvVarsWithInheritance() throws Exception {
        Assume.assumeFalse((boolean)Shell.WINDOWS);
        this.testEnvHelper(true);
    }

    @Test
    public void testEnvVarsWithoutInheritance() throws Exception {
        Assume.assumeFalse((boolean)Shell.WINDOWS);
        this.testEnvHelper(false);
    }

    private void testEnvHelper(boolean inheritParentEnv) throws Exception {
        Map<String, String> customEnv = Collections.singletonMap("HADOOP_CREDSTORE_PASSWORD", "foo");
        Shell.ShellCommandExecutor command = new Shell.ShellCommandExecutor(new String[]{"env"}, null, customEnv, 0L, inheritParentEnv);
        command.execute();
        String[] varsArr = command.getOutput().split("\n");
        HashMap<String, String> vars = new HashMap<String, String>();
        for (String var : varsArr) {
            int eqIndex = var.indexOf(61);
            vars.put(var.substring(0, eqIndex), var.substring(eqIndex + 1));
        }
        HashMap<String, String> expectedEnv = new HashMap<String, String>();
        expectedEnv.putAll(System.getenv());
        if (inheritParentEnv) {
            expectedEnv.putAll(customEnv);
        } else {
            TestShell.assertFalse((String)"child process environment should not have contained HADOOP_CREDSTORE_PASSWORD", (boolean)vars.containsKey("HADOOP_CREDSTORE_PASSWORD"));
        }
        TestShell.assertEquals(expectedEnv, vars);
    }

    private static int countTimerThreads() {
        ThreadInfo[] infos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        int count = 0;
        block0: for (ThreadInfo info : infos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), 20)) {
            if (info == null) continue;
            for (StackTraceElement elem : info.getStackTrace()) {
                if (!elem.getClassName().contains("Timer")) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public void testShellCommandTimerLeak() throws Exception {
        String[] quickCommand = new String[]{"/bin/sleep", "100"};
        int timersBefore = TestShell.countTimerThreads();
        System.err.println("before: " + timersBefore);
        for (int i = 0; i < 10; ++i) {
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(quickCommand, null, null, 1L);
            try {
                shexec.execute();
                TestShell.fail((String)"Bad command should throw exception");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread.sleep(1000L);
        int timersAfter = TestShell.countTimerThreads();
        System.err.println("after: " + timersAfter);
        TestShell.assertEquals((int)timersBefore, (int)timersAfter);
    }

    private void testInterval(long interval) throws IOException {
        Command command = new Command(interval);
        command.run();
        TestShell.assertEquals((int)1, (int)command.getRunCount());
        command.run();
        if (interval > 0L) {
            TestShell.assertEquals((int)1, (int)command.getRunCount());
        } else {
            TestShell.assertEquals((int)2, (int)command.getRunCount());
        }
    }

    @Test
    public void testBashQuote() {
        TestShell.assertEquals((String)"'foobar'", (String)Shell.bashQuote((String)"foobar"));
        TestShell.assertEquals((String)"'foo'\\''bar'", (String)Shell.bashQuote((String)"foo'bar"));
        TestShell.assertEquals((String)"''\\''foo'\\''bar'\\'''", (String)Shell.bashQuote((String)"'foo'bar'"));
    }

    private static class Command
    extends Shell {
        private int runCount = 0;

        private Command(long interval) {
            super(interval);
        }

        protected String[] getExecString() {
            String[] stringArray;
            if (Shell.WINDOWS) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "cmd.exe";
                stringArray2[1] = "/c";
                stringArray2[2] = "echo";
                stringArray = stringArray2;
                stringArray2[3] = "hello";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "echo";
                stringArray = stringArray3;
                stringArray3[1] = "hello";
            }
            return stringArray;
        }

        protected void parseExecResult(BufferedReader lines) throws IOException {
            ++this.runCount;
        }

        public int getRunCount() {
            return this.runCount;
        }
    }
}

