/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.conf.HadoopKeyValuesBasedBaseEdgeConfig;
import org.apache.tez.runtime.library.conf.UnorderedKVInputConfig;
import org.apache.tez.runtime.library.conf.UnorderedKVOutputConfig;
import org.apache.tez.runtime.library.conf.Utils;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.UnorderedKVOutput;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class UnorderedKVEdgeConfig
extends HadoopKeyValuesBasedBaseEdgeConfig {
    private final UnorderedKVOutputConfig outputConf;
    private final UnorderedKVInputConfig inputConf;

    private UnorderedKVEdgeConfig(UnorderedKVOutputConfig outputConfiguration, UnorderedKVInputConfig inputConfiguration) {
        this.outputConf = outputConfiguration;
        this.inputConf = inputConfiguration;
    }

    public static Builder newBuilder(String keyClassName, String valueClassName) {
        return new Builder(keyClassName, valueClassName);
    }

    @Override
    public UserPayload getOutputPayload() {
        return this.outputConf.toUserPayload();
    }

    @Override
    public String getOutputClassName() {
        return UnorderedKVOutput.class.getName();
    }

    @Override
    public UserPayload getInputPayload() {
        return this.inputConf.toUserPayload();
    }

    @Override
    public String getOutputHistoryText() {
        return this.outputConf.toHistoryText();
    }

    @Override
    public String getInputHistoryText() {
        return this.inputConf.toHistoryText();
    }

    @Override
    public String getInputClassName() {
        return UnorderedKVInput.class.getName();
    }

    public EdgeProperty createDefaultBroadcastEdgeProperty() {
        EdgeProperty edgeProperty = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.BROADCAST, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.getOutputClassName()).setUserPayload(this.getOutputPayload())), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.getInputClassName()).setUserPayload(this.getInputPayload())));
        Utils.setEdgePropertyHistoryText(this, edgeProperty);
        return edgeProperty;
    }

    public EdgeProperty createDefaultOneToOneEdgeProperty() {
        EdgeProperty edgeProperty = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.getOutputClassName()).setUserPayload(this.getOutputPayload())), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.getInputClassName()).setUserPayload(this.getInputPayload())));
        Utils.setEdgePropertyHistoryText(this, edgeProperty);
        return edgeProperty;
    }

    public EdgeProperty createDefaultCustomEdgeProperty(EdgeManagerPluginDescriptor edgeManagerDescriptor) {
        Preconditions.checkNotNull((Object)edgeManagerDescriptor, (Object)"EdgeManagerDescriptor cannot be null");
        EdgeProperty edgeProperty = EdgeProperty.create((EdgeManagerPluginDescriptor)edgeManagerDescriptor, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.getOutputClassName()).setUserPayload(this.getOutputPayload())), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.getInputClassName()).setUserPayload(this.getInputPayload())));
        Utils.setEdgePropertyHistoryText(this, edgeProperty);
        return edgeProperty;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Builder
    extends HadoopKeyValuesBasedBaseEdgeConfig.Builder<Builder> {
        private final UnorderedKVOutputConfig.Builder outputBuilder = new UnorderedKVOutputConfig.Builder();
        private final UnorderedKVOutputConfig.SpecificBuilder<Builder> specificOutputBuilder = new UnorderedKVOutputConfig.SpecificBuilder<Builder>(this, this.outputBuilder);
        private final UnorderedKVInputConfig.Builder inputBuilder = new UnorderedKVInputConfig.Builder();
        private final UnorderedKVInputConfig.SpecificBuilder<Builder> specificInputBuilder = new UnorderedKVInputConfig.SpecificBuilder<Builder>(this, this.inputBuilder);

        @InterfaceAudience.Private
        Builder(String keyClassName, String valueClassName) {
            this.outputBuilder.setKeyClassName(keyClassName);
            this.outputBuilder.setValueClassName(valueClassName);
            this.inputBuilder.setKeyClassName(keyClassName);
            this.inputBuilder.setValueClassName(valueClassName);
        }

        @Override
        public Builder setCompression(boolean enabled, @Nullable String compressionCodec, @Nullable Map<String, String> codecConf) {
            this.outputBuilder.setCompression(enabled, compressionCodec, codecConf);
            this.inputBuilder.setCompression(enabled, compressionCodec, codecConf);
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(String key, String value) {
            this.outputBuilder.setAdditionalConfiguration(key, value);
            this.inputBuilder.setAdditionalConfiguration(key, value);
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(Map<String, String> confMap) {
            this.outputBuilder.setAdditionalConfiguration((Map)confMap);
            this.inputBuilder.setAdditionalConfiguration((Map)confMap);
            return this;
        }

        @Override
        public Builder setFromConfiguration(Configuration conf) {
            this.outputBuilder.setFromConfiguration(conf);
            this.inputBuilder.setFromConfiguration(conf);
            return this;
        }

        public Builder setKeySerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            this.outputBuilder.setKeySerializationClass(serializationClassName, serializerConf);
            this.inputBuilder.setKeySerializationClass(serializationClassName, serializerConf);
            return this;
        }

        public Builder setValueSerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            this.outputBuilder.setValueSerializationClass(serializationClassName, serializerConf);
            this.inputBuilder.setValueSerializationClass(serializationClassName, serializerConf);
            return this;
        }

        public UnorderedKVOutputConfig.SpecificBuilder<Builder> configureOutput() {
            return this.specificOutputBuilder;
        }

        public UnorderedKVInputConfig.SpecificBuilder<Builder> configureInput() {
            return this.specificInputBuilder;
        }

        public UnorderedKVEdgeConfig build() {
            return new UnorderedKVEdgeConfig(this.outputBuilder.build(), this.inputBuilder.build());
        }
    }
}

