/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.HDFSCacheTaskLocation;
import org.apache.spark.scheduler.HostTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class TaskLocation$ {
    public static final TaskLocation$ MODULE$;
    private final String inMemoryLocationTag;
    private final String executorLocationTag;

    static {
        new TaskLocation$();
    }

    public String inMemoryLocationTag() {
        return this.inMemoryLocationTag;
    }

    public String executorLocationTag() {
        return this.executorLocationTag;
    }

    public TaskLocation apply(String host, String executorId) {
        return new ExecutorCacheTaskLocation(host, executorId);
    }

    public TaskLocation apply(String str) {
        Product product;
        String hstr = new StringOps(Predef$.MODULE$.augmentString(str)).stripPrefix(this.inMemoryLocationTag());
        if (hstr.equals(str)) {
            if (str.startsWith(this.executorLocationTag())) {
                String[] splits = str.split("_");
                if (splits.length != 3) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal executor location format: ").append((Object)str).toString());
                }
                product = new ExecutorCacheTaskLocation(splits[1], splits[2]);
            } else {
                product = new HostTaskLocation(str);
            }
        } else {
            product = new HDFSCacheTaskLocation(hstr);
        }
        return product;
    }

    private TaskLocation$() {
        MODULE$ = this;
        this.inMemoryLocationTag = "hdfs_cache_";
        this.executorLocationTag = "executor_";
    }
}

