/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStore;
import org.apache.spark.storage.DiskBlockManager;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.PutResult;
import org.apache.spark.storage.PutResult$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005}b!B\u0001\u0003\u0001\u0011Q!!\u0003#jg.\u001cFo\u001c:f\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0010!\taQ\"D\u0001\u0003\u0013\tq!A\u0001\u0006CY>\u001c7n\u0015;pe\u0016\u0004\"\u0001E\t\u000e\u0003\u0011I!A\u0005\u0003\u0003\u000f1{wmZ5oO\"IA\u0003\u0001B\u0001B\u0003%a#G\u0001\rE2|7m['b]\u0006<WM]\u0002\u0001!\taq#\u0003\u0002\u0019\u0005\ta!\t\\8dW6\u000bg.Y4fe&\u0011A#\u0004\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005YA-[:l\u001b\u0006t\u0017mZ3s!\taQ$\u0003\u0002\u001f\u0005\t\u0001B)[:l\u00052|7m['b]\u0006<WM\u001d\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\u001aC\u0005\u0005\u0002\r\u0001!)Ac\ba\u0001-!)1d\ba\u00019!9a\u0005\u0001b\u0001\n\u00039\u0013!E7j]6+Wn\u001c:z\u001b\u0006\u0004()\u001f;fgV\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0003M_:<\u0007BB\u0018\u0001A\u0003%\u0001&\u0001\nnS:lU-\\8ss6\u000b\u0007OQ=uKN\u0004\u0003\"B\u0019\u0001\t\u0003\u0012\u0014aB4fiNK'0\u001a\u000b\u0003QMBQ\u0001\u000e\u0019A\u0002U\nqA\u00197pG.LE\r\u0005\u0002\rm%\u0011qG\u0001\u0002\b\u00052|7m[%e\u0011\u0015I\u0004\u0001\"\u0011;\u0003!\u0001X\u000f\u001e\"zi\u0016\u001cH\u0003B\u001e?\u007f%\u0003\"\u0001\u0004\u001f\n\u0005u\u0012!!\u0003)viJ+7/\u001e7u\u0011\u0015!\u0004\b1\u00016\u0011\u0015\u0001\u0005\b1\u0001B\u0003\u0019y&-\u001f;fgB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0004]&|'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013!BQ=uK\n+hMZ3s\u0011\u0015Q\u0005\b1\u0001L\u0003\u0015aWM^3m!\taA*\u0003\u0002N\u0005\ta1\u000b^8sC\u001e,G*\u001a<fY\")q\n\u0001C!!\u0006A\u0001/\u001e;BeJ\f\u0017\u0010F\u0003<#JS6\fC\u00035\u001d\u0002\u0007Q\u0007C\u0003T\u001d\u0002\u0007A+\u0001\u0004wC2,Xm\u001d\t\u0004SU;\u0016B\u0001,+\u0005\u0015\t%O]1z!\tI\u0003,\u0003\u0002ZU\t\u0019\u0011I\\=\t\u000b)s\u0005\u0019A&\t\u000bqs\u0005\u0019A/\u0002\u0019I,G/\u001e:o-\u0006dW/Z:\u0011\u0005%r\u0016BA0+\u0005\u001d\u0011un\u001c7fC:DQ!\u0019\u0001\u0005B\t\f1\u0002];u\u0013R,'/\u0019;peR)1h\u00193re\")A\u0007\u0019a\u0001k!)1\u000b\u0019a\u0001KB\u0019aM\\,\u000f\u0005\u001ddgB\u00015l\u001b\u0005I'B\u00016\u0016\u0003\u0019a$o\\8u}%\t1&\u0003\u0002nU\u00059\u0001/Y2lC\u001e,\u0017BA8q\u0005!IE/\u001a:bi>\u0014(BA7+\u0011\u0015Q\u0005\r1\u0001L\u0011\u0015a\u0006\r1\u0001^\u0011\u0015!\b\u0001\"\u0003v\u0003!9W\r\u001e\"zi\u0016\u001cHC\u0002<z\u0003\u0007\t9\u0001E\u0002*o\u0006K!\u0001\u001f\u0016\u0003\r=\u0003H/[8o\u0011\u0015Q8\u000f1\u0001|\u0003\u00111\u0017\u000e\\3\u0011\u0005q|X\"A?\u000b\u0005y,\u0015AA5p\u0013\r\t\t! \u0002\u0005\r&dW\r\u0003\u0004\u0002\u0006M\u0004\r\u0001K\u0001\u0007_\u001a47/\u001a;\t\r\u0005%1\u000f1\u0001)\u0003\u0019aWM\\4uQ\"1A\u000f\u0001C!\u0003\u001b!2A^A\b\u0011\u0019!\u00141\u0002a\u0001k!1A\u000f\u0001C\u0001\u0003'!2A^A\u000b\u0011!\t9\"!\u0005A\u0002\u0005e\u0011aB:fO6,g\u000e\u001e\t\u0004\u0019\u0005m\u0011bAA\u000f\u0005\tYa)\u001b7f'\u0016<W.\u001a8u\u0011\u001d\t\t\u0003\u0001C!\u0003G\t\u0011bZ3u-\u0006dW/Z:\u0015\t\u0005\u0015\u0012q\u0005\t\u0004S],\u0007B\u0002\u001b\u0002 \u0001\u0007Q\u0007C\u0004\u0002,\u0001!\t%!\f\u0002\rI,Wn\u001c<f)\ri\u0016q\u0006\u0005\u0007i\u0005%\u0002\u0019A\u001b\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005A1m\u001c8uC&t7\u000fF\u0002^\u0003oAa\u0001NA\u0019\u0001\u0004)\u0004\"DA\u001e\u0001A\u0005\u0019\u0011!A\u0005\n\u0005u\u0012$\u0001\ntkB,'\u000f\n2m_\u000e\\W*\u00198bO\u0016\u0014X#\u0001\f")
public class DiskStore
extends BlockStore {
    private final DiskBlockManager diskManager;
    private final long minMemoryMapBytes;

    public /* synthetic */ BlockManager org$apache$spark$storage$DiskStore$$super$blockManager() {
        return super.blockManager();
    }

    public long minMemoryMapBytes() {
        return this.minMemoryMapBytes;
    }

    @Override
    public long getSize(BlockId blockId) {
        return this.diskManager.getFile(blockId.name()).length();
    }

    @Override
    public PutResult putBytes(BlockId blockId, ByteBuffer _bytes, StorageLevel level) {
        ByteBuffer bytes = _bytes.duplicate();
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to put block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
        long startTime = System.currentTimeMillis();
        File file = this.diskManager.getFile(blockId);
        FileChannel channel = new FileOutputStream(file).getChannel();
        Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, bytes, channel){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer bytes$1;
            private final FileChannel channel$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (this.bytes$1.remaining() > 0) {
                    this.channel$1.write(this.bytes$1);
                }
            }
            {
                this.bytes$1 = bytes$1;
                this.channel$1 = channel$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(this, channel){
            public static final long serialVersionUID = 0L;
            private final FileChannel channel$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.channel$1.close();
            }
            {
                this.channel$1 = channel$1;
            }
        });
        long finishTime = System.currentTimeMillis();
        this.logDebug((Function0<String>)new Serializable(this, bytes, startTime, file, finishTime){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer bytes$1;
            private final long startTime$1;
            private final File file$1;
            private final long finishTime$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file on disk in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getName(), Utils$.MODULE$.bytesToString(this.bytes$1.limit()), BoxesRunTime.boxToLong((long)(this.finishTime$1 - this.startTime$1))}));
            }
            {
                this.bytes$1 = bytes$1;
                this.startTime$1 = startTime$1;
                this.file$1 = file$1;
                this.finishTime$1 = finishTime$1;
            }
        });
        return new PutResult(bytes.limit(), (Either<Iterator<?>, ByteBuffer>)package$.MODULE$.Right().apply((Object)bytes.duplicate()), PutResult$.MODULE$.apply$default$3());
    }

    @Override
    public PutResult putArray(BlockId blockId, Object[] values2, StorageLevel level, boolean returnValues) {
        return this.putIterator(blockId, (Iterator<Object>)Predef$.MODULE$.genericArrayOps((Object)values2).toIterator(), level, returnValues);
    }

    @Override
    public PutResult putIterator(BlockId blockId, Iterator<Object> values2, StorageLevel level, boolean returnValues) {
        PutResult putResult;
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to write values for block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$2}));
            }
            {
                this.blockId$2 = blockId$2;
            }
        });
        long startTime = System.currentTimeMillis();
        File file = this.diskManager.getFile(blockId);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, blockId, values2, outputStream){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskStore $outer;
                private final BlockId blockId$2;
                private final Iterator values$1;
                private final FileOutputStream outputStream$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$spark$storage$DiskStore$$super$blockManager().dataSerializeStream(this.blockId$2, this.outputStream$1, (Iterator<Object>)this.values$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.blockId$2 = blockId$2;
                    this.values$1 = values$1;
                    this.outputStream$1 = outputStream$1;
                }
            }, (Function0<BoxedUnit>)new Serializable(this, outputStream){
                public static final long serialVersionUID = 0L;
                private final FileOutputStream outputStream$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.outputStream$1.close();
                }
                {
                    this.outputStream$1 = outputStream$1;
                }
            });
        }
        catch (Throwable throwable) {
            if (file.exists() && !file.delete()) {
                this.logWarning((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
                    }
                    {
                        this.file$2 = file$2;
                    }
                });
            }
            throw throwable;
        }
        long length = file.length();
        long timeTaken = System.currentTimeMillis() - startTime;
        this.logDebug((Function0<String>)new Serializable(this, file, length, timeTaken){
            public static final long serialVersionUID = 0L;
            private final File file$2;
            private final long length$1;
            private final long timeTaken$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file on disk in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2.getName(), Utils$.MODULE$.bytesToString(this.length$1), BoxesRunTime.boxToLong((long)this.timeTaken$1)}));
            }
            {
                this.file$2 = file$2;
                this.length$1 = length$1;
                this.timeTaken$1 = timeTaken$1;
            }
        });
        if (returnValues) {
            ByteBuffer buffer = (ByteBuffer)this.getBytes(blockId).get();
            putResult = new PutResult(length, (Either<Iterator<?>, ByteBuffer>)package$.MODULE$.Right().apply((Object)buffer), PutResult$.MODULE$.apply$default$3());
        } else {
            putResult = new PutResult(length, null, PutResult$.MODULE$.apply$default$3());
        }
        return putResult;
    }

    private Option<ByteBuffer> getBytes(File file, long offset, long length) {
        FileChannel channel = new RandomAccessFile(file, "r").getChannel();
        return (Option)Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, file, offset, length, channel){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DiskStore $outer;
            private final File file$3;
            private final long offset$1;
            private final long length$2;
            private final FileChannel channel$2;

            public final Some<ByteBuffer> apply() {
                Some some;
                if (this.length$2 < this.$outer.minMemoryMapBytes()) {
                    ByteBuffer buf = ByteBuffer.allocate((int)this.length$2);
                    this.channel$2.position(this.offset$1);
                    while (buf.remaining() != 0) {
                        if (this.channel$2.read(buf) != -1) continue;
                        throw new IOException(new StringBuilder().append((Object)"Reached EOF before filling buffer\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset=", "\\nfile=", "\\nbuf.remaining=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), this.file$3.getAbsolutePath(), BoxesRunTime.boxToInteger((int)buf.remaining())}))).toString());
                    }
                    buf.flip();
                    some = new Some((Object)buf);
                } else {
                    some = new Some((Object)this.channel$2.map(FileChannel.MapMode.READ_ONLY, this.offset$1, this.length$2));
                }
                return some;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.file$3 = file$3;
                this.offset$1 = offset$1;
                this.length$2 = length$2;
                this.channel$2 = channel$2;
            }
        }, (Function0<BoxedUnit>)new Serializable(this, channel){
            public static final long serialVersionUID = 0L;
            private final FileChannel channel$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.channel$2.close();
            }
            {
                this.channel$2 = channel$2;
            }
        });
    }

    @Override
    public Option<ByteBuffer> getBytes(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        return this.getBytes(file, 0L, file.length());
    }

    public Option<ByteBuffer> getBytes(FileSegment segment) {
        return this.getBytes(segment.file(), segment.offset(), segment.length());
    }

    @Override
    public Option<Iterator<Object>> getValues(BlockId blockId) {
        return this.getBytes(blockId).map((Function1)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DiskStore $outer;
            private final BlockId blockId$3;

            public final Iterator<Object> apply(ByteBuffer buffer) {
                return this.$outer.org$apache$spark$storage$DiskStore$$super$blockManager().dataDeserialize(this.blockId$3, buffer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$3 = blockId$3;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(BlockId blockId) {
        boolean bl;
        File file = this.diskManager.getFile(blockId.name());
        if (file.exists()) {
            void var3_3;
            boolean ret = file.delete();
            if (!ret) {
                this.logWarning((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$4;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$4.getPath()}));
                    }
                    {
                        this.file$4 = file$4;
                    }
                });
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean contains(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        return file.exists();
    }

    public DiskStore(BlockManager blockManager2, DiskBlockManager diskManager) {
        this.diskManager = diskManager;
        super(blockManager2);
        this.minMemoryMapBytes = super.blockManager().conf().getSizeAsBytes("spark.storage.memoryMapThreshold", "2m");
    }
}

