/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.util.Comparator;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.util.collection.Sorter;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordPointerAndKeyPrefix;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSortDataFormat;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;

public final class UnsafeInMemorySorter {
    private final MemoryConsumer consumer;
    private final TaskMemoryManager memoryManager;
    private final Sorter<RecordPointerAndKeyPrefix, LongArray> sorter;
    private final Comparator<RecordPointerAndKeyPrefix> sortComparator;
    private LongArray array;
    private int pos = 0;

    public UnsafeInMemorySorter(MemoryConsumer consumer, TaskMemoryManager memoryManager, RecordComparator recordComparator, PrefixComparator prefixComparator, int initialSize) {
        this(consumer, memoryManager, recordComparator, prefixComparator, consumer.allocateArray(initialSize * 2));
    }

    public UnsafeInMemorySorter(MemoryConsumer consumer, TaskMemoryManager memoryManager, RecordComparator recordComparator, PrefixComparator prefixComparator, LongArray array) {
        this.consumer = consumer;
        this.memoryManager = memoryManager;
        this.sorter = new Sorter<RecordPointerAndKeyPrefix, LongArray>(UnsafeSortDataFormat.INSTANCE);
        this.sortComparator = new SortComparator(recordComparator, prefixComparator, memoryManager);
        this.array = array;
    }

    public void free() {
        if (this.consumer != null) {
            this.consumer.freeArray(this.array);
            this.array = null;
        }
    }

    public void reset() {
        this.pos = 0;
    }

    public int numRecords() {
        return this.pos / 2;
    }

    public long getMemoryUsage() {
        return this.array.size() * 8L;
    }

    public boolean hasSpaceForAnotherRecord() {
        return (long)(this.pos + 2) <= this.array.size();
    }

    public void expandPointerArray(LongArray newArray) {
        if (newArray.size() < this.array.size()) {
            throw new OutOfMemoryError("Not enough memory to grow pointer array");
        }
        Platform.copyMemory((Object)this.array.getBaseObject(), (long)this.array.getBaseOffset(), (Object)newArray.getBaseObject(), (long)newArray.getBaseOffset(), (long)(this.array.size() * 8L));
        this.consumer.freeArray(this.array);
        this.array = newArray;
    }

    public void insertRecord(long recordPointer, long keyPrefix) {
        if (!this.hasSpaceForAnotherRecord()) {
            throw new IllegalStateException("There is no space for new record");
        }
        this.array.set(this.pos, recordPointer);
        ++this.pos;
        this.array.set(this.pos, keyPrefix);
        ++this.pos;
    }

    public SortedIterator getSortedIterator() {
        this.sorter.sort(this.array, 0, this.pos / 2, this.sortComparator);
        return new SortedIterator(this.pos / 2);
    }

    public final class SortedIterator
    extends UnsafeSorterIterator {
        private final int numRecords;
        private int position;
        private Object baseObject;
        private long baseOffset;
        private long keyPrefix;
        private int recordLength;

        private SortedIterator(int numRecords) {
            this.numRecords = numRecords;
            this.position = 0;
        }

        public SortedIterator clone() {
            SortedIterator iter = new SortedIterator(this.numRecords);
            iter.position = this.position;
            iter.baseObject = this.baseObject;
            iter.baseOffset = this.baseOffset;
            iter.keyPrefix = this.keyPrefix;
            iter.recordLength = this.recordLength;
            return iter;
        }

        @Override
        public boolean hasNext() {
            return this.position / 2 < this.numRecords;
        }

        public int numRecordsLeft() {
            return this.numRecords - this.position / 2;
        }

        @Override
        public void loadNext() {
            long recordPointer = UnsafeInMemorySorter.this.array.get(this.position);
            this.baseObject = UnsafeInMemorySorter.this.memoryManager.getPage(recordPointer);
            this.baseOffset = UnsafeInMemorySorter.this.memoryManager.getOffsetInPage(recordPointer) + 4L;
            this.recordLength = Platform.getInt((Object)this.baseObject, (long)(this.baseOffset - 4L));
            this.keyPrefix = UnsafeInMemorySorter.this.array.get(this.position + 1);
            this.position += 2;
        }

        @Override
        public Object getBaseObject() {
            return this.baseObject;
        }

        @Override
        public long getBaseOffset() {
            return this.baseOffset;
        }

        @Override
        public int getRecordLength() {
            return this.recordLength;
        }

        @Override
        public long getKeyPrefix() {
            return this.keyPrefix;
        }
    }

    private static final class SortComparator
    implements Comparator<RecordPointerAndKeyPrefix> {
        private final RecordComparator recordComparator;
        private final PrefixComparator prefixComparator;
        private final TaskMemoryManager memoryManager;

        SortComparator(RecordComparator recordComparator, PrefixComparator prefixComparator, TaskMemoryManager memoryManager) {
            this.recordComparator = recordComparator;
            this.prefixComparator = prefixComparator;
            this.memoryManager = memoryManager;
        }

        @Override
        public int compare(RecordPointerAndKeyPrefix r1, RecordPointerAndKeyPrefix r2) {
            int prefixComparisonResult = this.prefixComparator.compare(r1.keyPrefix, r2.keyPrefix);
            if (prefixComparisonResult == 0) {
                Object baseObject1 = this.memoryManager.getPage(r1.recordPointer);
                long baseOffset1 = this.memoryManager.getOffsetInPage(r1.recordPointer) + 4L;
                Object baseObject2 = this.memoryManager.getPage(r2.recordPointer);
                long baseOffset2 = this.memoryManager.getOffsetInPage(r2.recordPointer) + 4L;
                return this.recordComparator.compare(baseObject1, baseOffset1, baseObject2, baseOffset2);
            }
            return prefixComparisonResult;
        }
    }
}

