/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;

public class ScreenResolutionDissector
extends Dissector {
    public static final String SCREENRESOLUTION = "SCREENRESOLUTION";
    private String separator = "x";
    private boolean wantWidth = false;
    private boolean wantHeight = false;

    public boolean initializeFromSettingsParameter(String settings) {
        if (settings.length() > 0) {
            this.separator = settings;
        }
        return true;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(SCREENRESOLUTION, inputname);
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        if (fieldValue.contains(this.separator)) {
            String[] parts = fieldValue.split(this.separator);
            if (this.wantWidth) {
                parsable.addDissection(inputname, "SCREENWIDTH", "width", parts[0]);
            }
            if (this.wantHeight) {
                parsable.addDissection(inputname, "SCREENHEIGHT", "height", parts[1]);
            }
        }
    }

    public String getInputType() {
        return SCREENRESOLUTION;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("SCREENWIDTH:width");
        result.add("SCREENHEIGHT:height");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name = outputname.substring(inputname.length() + 1);
        if ("width".equals(name)) {
            this.wantWidth = true;
            return Casts.STRING_OR_LONG;
        }
        if ("height".equals(name)) {
            this.wantHeight = true;
            return Casts.STRING_OR_LONG;
        }
        return null;
    }

    public void prepareForRun() throws InvalidDissectorException {
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }
}

