/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class DataFileWriteTool
implements Tool {
    @Override
    public String getName() {
        return "fromjson";
    }

    @Override
    public String getShortDescription() {
        return "Reads JSON records and writes an Avro data file.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec codec = p.accepts("codec", "Compression codec").withRequiredArg().defaultsTo((Object)"null", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec file = p.accepts("schema-file", "Schema File").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec inschema = p.accepts("schema", "Schema").withOptionalArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        List nargs = opts.nonOptionArguments();
        if (nargs.size() != 1) {
            err.println("Expected 1 arg: input_file");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        String schemastr = (String)inschema.value(opts);
        String schemafile = (String)file.value(opts);
        if (schemastr == null && schemafile == null) {
            err.println("Need an input schema file (--schema-file) or inline schema (--schema)");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        Schema schema = schemafile != null ? new Schema.Parser().parse(Util.openFromFS(schemafile)) : new Schema.Parser().parse(schemastr);
        GenericDatumReader reader = new GenericDatumReader(schema);
        BufferedInputStream input = Util.fileOrStdin((String)nargs.get(0), stdin);
        try {
            DataInputStream din = new DataInputStream(input);
            DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
            writer.setCodec(CodecFactory.fromString((String)((String)codec.value(opts))));
            writer.create(schema, (OutputStream)out);
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)din);
            while (true) {
                Object datum;
                try {
                    datum = reader.read(null, (Decoder)decoder);
                }
                catch (EOFException e) {
                    break;
                }
                writer.append(datum);
            }
            writer.close();
        }
        finally {
            Util.close(input);
        }
        return 0;
    }
}

