/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.spark-project.guava.base.Objects;

public final class RpcFailure
extends AbstractMessage
implements ResponseMessage {
    public final long requestId;
    public final String errorString;

    public RpcFailure(long requestId, String errorString) {
        this.requestId = requestId;
        this.errorString = errorString;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RpcFailure;
    }

    @Override
    public int encodedLength() {
        return 8 + Encoders.Strings.encodedLength(this.errorString);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        Encoders.Strings.encode(buf, this.errorString);
    }

    public static RpcFailure decode(ByteBuf buf) {
        long requestId = buf.readLong();
        String errorString = Encoders.Strings.decode(buf);
        return new RpcFailure(requestId, errorString);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestId, this.errorString);
    }

    public boolean equals(Object other) {
        if (other instanceof RpcFailure) {
            RpcFailure o = (RpcFailure)other;
            return this.requestId == o.requestId && this.errorString.equals(o.errorString);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("requestId", this.requestId).add("errorString", this.errorString).toString();
    }
}

