/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import java.nio.ByteBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcHandler {
    private static final RpcResponseCallback ONE_WAY_CALLBACK = new OneWayRpcCallback();

    public abstract void receive(TransportClient var1, ByteBuffer var2, RpcResponseCallback var3);

    public abstract StreamManager getStreamManager();

    public void receive(TransportClient client, ByteBuffer message) {
        this.receive(client, message, ONE_WAY_CALLBACK);
    }

    public void connectionTerminated(TransportClient client) {
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
    }

    private static class OneWayRpcCallback
    implements RpcResponseCallback {
        private final Logger logger = LoggerFactory.getLogger(OneWayRpcCallback.class);

        private OneWayRpcCallback() {
        }

        @Override
        public void onSuccess(ByteBuffer response) {
            this.logger.warn("Response provided for one-way RPC.");
        }

        @Override
        public void onFailure(Throwable e) {
            this.logger.error("Error response provided for one-way RPC.", e);
        }
    }
}

