/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.MasterClientBase;
import tachyon.TachyonURI;
import tachyon.conf.TachyonConf;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.RawTableInfo;
import tachyon.thrift.RawTableMasterService;

public final class RawTableMasterClient
extends MasterClientBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private RawTableMasterService.Client mClient = null;

    public RawTableMasterClient(InetSocketAddress masterAddress, TachyonConf tachyonConf) {
        super(masterAddress, tachyonConf);
    }

    @Override
    protected String getServiceName() {
        return "RawTableMaster";
    }

    @Override
    protected void afterConnect() {
        this.mClient = new RawTableMasterService.Client(this.mProtocol);
    }

    public synchronized long createRawTable(final TachyonURI path, final int columns, final ByteBuffer metadata) throws IOException {
        return this.retryRPC(new RpcCallable<Long>(){

            @Override
            public Long call() throws TException {
                return RawTableMasterClient.this.mClient.createRawTable(path.getPath(), columns, metadata);
            }
        });
    }

    public synchronized RawTableInfo getClientRawTableInfo(final long id) throws IOException {
        return this.retryRPC(new RpcCallable<RawTableInfo>(){

            @Override
            public RawTableInfo call() throws TException {
                return RawTableMasterClient.this.mClient.getClientRawTableInfoById(id);
            }
        });
    }

    public synchronized RawTableInfo getClientRawTableInfo(final TachyonURI path) throws IOException {
        return this.retryRPC(new RpcCallable<RawTableInfo>(){

            @Override
            public RawTableInfo call() throws TException {
                return RawTableMasterClient.this.mClient.getClientRawTableInfoByPath(path.getPath());
            }
        });
    }

    public void updateRawTableMetadata(final long tableId, final ByteBuffer metadata) throws IOException {
        this.retryRPC(new RpcCallable<Void>(){

            @Override
            public Void call() throws TException {
                RawTableMasterClient.this.mClient.updateRawTableMetadata(tableId, metadata);
                return null;
            }
        });
    }

    private <V> V retryRPC(RpcCallable<V> rpc) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return rpc.call();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    private static interface RpcCallable<V> {
        public V call() throws TException;
    }
}

