/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file.options;

import tachyon.client.ClientContext;
import tachyon.client.ReadType;
import tachyon.client.TachyonStorageType;
import tachyon.conf.TachyonConf;

public final class InStreamOptions {
    private final TachyonStorageType mTachyonStorageType;

    public static InStreamOptions defaults() {
        return new Builder(ClientContext.getConf()).build();
    }

    private InStreamOptions(Builder builder) {
        this.mTachyonStorageType = builder.mTachyonStorageType;
    }

    public TachyonStorageType getTachyonStorageType() {
        return this.mTachyonStorageType;
    }

    public static class Builder {
        private TachyonStorageType mTachyonStorageType;

        public Builder(TachyonConf conf) {
            ReadType defaultReadType = conf.getEnum("tachyon.user.file.readtype.default", ReadType.class);
            this.mTachyonStorageType = defaultReadType.getTachyonStorageType();
        }

        public Builder setReadType(ReadType readType) {
            this.mTachyonStorageType = readType.getTachyonStorageType();
            return this;
        }

        public Builder setTachyonStorageType(TachyonStorageType tachyonStorageType) {
            this.mTachyonStorageType = tachyonStorageType;
            return this;
        }

        public InStreamOptions build() {
            return new InStreamOptions(this);
        }
    }
}

