/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.conf.TachyonConf;
import tachyon.exception.TachyonExceptionType;
import tachyon.heartbeat.HeartbeatExecutor;
import tachyon.heartbeat.HeartbeatThread;
import tachyon.org.apache.thrift.TException;
import tachyon.org.apache.thrift.protocol.TBinaryProtocol;
import tachyon.org.apache.thrift.protocol.TProtocol;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.security.authentication.AuthenticationUtils;
import tachyon.thrift.NetAddress;
import tachyon.thrift.TachyonTException;
import tachyon.thrift.WorkerService;
import tachyon.util.network.NetworkAddressUtils;
import tachyon.worker.ClientMetrics;
import tachyon.worker.WorkerClientHeartbeatExecutor;

public final class WorkerClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static final int CONNECTION_RETRY_TIMES = 5;
    private final NetAddress mWorkerNetAddress;
    private final boolean mIsLocal;
    private WorkerService.Client mClient;
    private TProtocol mProtocol;
    private long mSessionId;
    private InetSocketAddress mWorkerAddress;
    private InetSocketAddress mWorkerDataServerAddress;
    private boolean mConnected = false;
    private final ExecutorService mExecutorService;
    private final HeartbeatExecutor mHeartbeatExecutor;
    private Future<?> mHeartbeat;
    private final TachyonConf mTachyonConf;
    private final ClientMetrics mClientMetrics;

    public WorkerClient(NetAddress workerNetAddress, ExecutorService executorService, TachyonConf conf, long sessionId, boolean isLocal, ClientMetrics clientMetrics) {
        this.mWorkerNetAddress = (NetAddress)Preconditions.checkNotNull((Object)workerNetAddress);
        this.mExecutorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.mTachyonConf = (TachyonConf)Preconditions.checkNotNull((Object)conf);
        this.mSessionId = sessionId;
        this.mIsLocal = isLocal;
        this.mClientMetrics = (ClientMetrics)Preconditions.checkNotNull((Object)clientMetrics);
        this.mHeartbeatExecutor = new WorkerClientHeartbeatExecutor(this);
    }

    public synchronized void accessBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.accessBlock(blockId);
        }
        catch (TException e) {
            LOG.error("TachyonClient accessLocalBlock(" + blockId + ") failed");
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void persistFile(long fileId, long nonce, String path) throws IOException {
        this.mustConnect();
        try {
            this.mClient.persistFile(fileId, nonce, path);
        }
        catch (TachyonTException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean asyncCheckpoint(long fileId) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.asyncCheckpoint(fileId);
        }
        catch (TachyonTException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void cacheBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.cacheBlock(this.mSessionId, blockId);
        }
        catch (TachyonTException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void cancelBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.cancelBlock(this.mSessionId, blockId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.mConnected) {
            try {
                if (this.mHeartbeatExecutor != null) {
                    this.mHeartbeatExecutor.heartbeat();
                }
                this.mProtocol.getTransport().close();
            }
            finally {
                if (this.mHeartbeat != null) {
                    this.mHeartbeat.cancel(true);
                }
            }
            this.mConnected = false;
        }
    }

    private synchronized boolean connect() throws IOException {
        if (!this.mConnected) {
            String host = NetworkAddressUtils.getFqdnHost(this.mWorkerNetAddress);
            int port = this.mWorkerNetAddress.rpcPort;
            this.mWorkerAddress = new InetSocketAddress(host, port);
            this.mWorkerDataServerAddress = new InetSocketAddress(host, this.mWorkerNetAddress.dataPort);
            LOG.info("Connecting " + (this.mIsLocal ? "local" : "remote") + " worker @ " + this.mWorkerAddress);
            this.mProtocol = new TBinaryProtocol(AuthenticationUtils.getClientTransport(this.mTachyonConf, new InetSocketAddress(host, port)));
            this.mClient = new WorkerService.Client(this.mProtocol);
            try {
                this.mProtocol.getTransport().open();
            }
            catch (TTransportException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            this.mConnected = true;
            if (this.mHeartbeat == null || this.mHeartbeat.isCancelled() || this.mHeartbeat.isDone()) {
                int interval = this.mTachyonConf.getInt("tachyon.user.heartbeat.interval.ms");
                this.mHeartbeat = this.mExecutorService.submit(new HeartbeatThread("Worker Client", this.mHeartbeatExecutor, interval));
            }
        }
        return this.mConnected;
    }

    public synchronized void createNewSession(long newSessionId) {
        this.mSessionId = newSessionId;
    }

    public synchronized InetSocketAddress getAddress() {
        return this.mWorkerAddress;
    }

    public synchronized InetSocketAddress getDataServerAddress() {
        return this.mWorkerDataServerAddress;
    }

    public synchronized long getSessionId() {
        return this.mSessionId;
    }

    public synchronized boolean isConnected() {
        return this.mConnected;
    }

    public synchronized boolean isLocal() {
        return this.mIsLocal;
    }

    public synchronized String lockBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.lockBlock(blockId, this.mSessionId);
        }
        catch (TachyonTException e) {
            if (e.getType().equals(TachyonExceptionType.FILE_DOES_NOT_EXIST.name())) {
                return null;
            }
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void mustConnect() throws IOException {
        int tries = 0;
        while (tries++ <= 5) {
            if (!this.connect()) continue;
            return;
        }
        throw new IOException("Failed to connect to the worker");
    }

    public synchronized boolean promoteBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.promoteBlock(blockId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized String requestBlockLocation(long blockId, long initialBytes) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.requestBlockLocation(this.mSessionId, blockId, initialBytes);
        }
        catch (TachyonTException e) {
            if (e.getType().equals(TachyonExceptionType.WORKER_OUT_OF_SPACE.name())) {
                throw new IOException("Failed to request " + initialBytes, e);
            }
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean requestSpace(long blockId, long requestBytes) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.requestSpace(this.mSessionId, blockId, requestBytes);
        }
        catch (TachyonTException e) {
            if (e.getType().equals(TachyonExceptionType.WORKER_OUT_OF_SPACE.name())) {
                return false;
            }
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean unlockBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.unlockBlock(blockId, this.mSessionId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void sessionHeartbeat() throws IOException {
        this.mustConnect();
        try {
            this.mClient.sessionHeartbeat(this.mSessionId, this.mClientMetrics.getHeartbeatData());
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void periodicHeartbeat() {
        block2: {
            try {
                this.sessionHeartbeat();
            }
            catch (IOException e) {
                LOG.error("Periodic heartbeat failed, cleaning up.", (Throwable)e);
                if (this.mHeartbeat == null) break block2;
                this.mHeartbeat.cancel(true);
                this.mHeartbeat = null;
            }
        }
    }
}

