/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigProcessor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Pair;

public class TezRuntimeUtil {
    private static final Log LOG = LogFactory.getLog(TezRuntimeUtil.class);

    public static Map<Object, Pair<Integer, Integer>> readReduceMapFromSample(TupleFactory tf) {
        HashMap reducerMap = Maps.newHashMap();
        Map<String, Object> distMap = null;
        if (PigProcessor.sampleMap == null) {
            LOG.info((Object)"Key distribution map is empty");
            return reducerMap;
        }
        distMap = PigProcessor.sampleMap;
        long start = System.currentTimeMillis();
        try {
            reducerMap = Maps.newHashMap();
            DataBag partitionList = (DataBag)distMap.get("partition.list");
            int totalReducers = Integer.valueOf("" + distMap.get("totalreducers"));
            for (Tuple idxTuple : partitionList) {
                Tuple keyT;
                Integer maxIndex = (Integer)idxTuple.get(idxTuple.size() - 1);
                Integer minIndex = (Integer)idxTuple.get(idxTuple.size() - 2);
                if (maxIndex < minIndex) {
                    maxIndex = totalReducers + maxIndex;
                }
                if (idxTuple.size() > 3) {
                    Tuple keyTuple = tf.newTuple();
                    for (int i = 0; i < idxTuple.size() - 2; ++i) {
                        keyTuple.append(idxTuple.get(i));
                    }
                    keyT = keyTuple;
                } else {
                    keyT = tf.newTuple(1);
                    keyT.set(0, idxTuple.get(0));
                }
                Integer cnt = maxIndex - minIndex;
                reducerMap.put(keyT, new Pair<Integer, Integer>(minIndex, cnt));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info((Object)("Initialized reducerMap. Time taken: " + (System.currentTimeMillis() - start)));
        return reducerMap;
    }
}

