/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.mortbay.util.ajax.JSON;

public class MiniHadoopClusterManager {
    private static final Log LOG = LogFactory.getLog(MiniHadoopClusterManager.class);
    private MiniMRClientCluster mr;
    private MiniDFSCluster dfs;
    private String writeDetails;
    private int numNodeManagers;
    private int numDataNodes;
    private int nnPort;
    private int rmPort;
    private int jhsPort;
    private HdfsServerConstants.StartupOption dfsOpts;
    private boolean noDFS;
    private boolean noMR;
    private String fs;
    private String writeConfig;
    private JobConf conf;

    private Options makeOptions() {
        Options options = new Options();
        Options options2 = options.addOption("nodfs", false, "Don't start a mini DFS cluster").addOption("nomr", false, "Don't start a mini MR cluster").addOption("nodemanagers", true, "How many nodemanagers to start (default 1)").addOption("datanodes", true, "How many datanodes to start (default 1)").addOption("format", false, "Format the DFS (default false)").addOption("nnport", true, "NameNode port (default 0--we choose)").addOption("namenode", true, "URL of the namenode (default is either the DFS cluster or a temporary dir)").addOption("rmport", true, "ResourceManager port (default 0--we choose)").addOption("jhsport", true, "JobHistoryServer port (default 0--we choose)");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withDescription((String)"Options to pass into configuration object");
        Options options3 = options2.addOption(OptionBuilder.create((String)"D"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Save configuration to this XML file.");
        Options options4 = options3.addOption(OptionBuilder.create((String)"writeConfig"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Write basic information to this JSON file.");
        Options options5 = options4.addOption(OptionBuilder.create((String)"writeDetails"));
        OptionBuilder.withDescription((String)"Prints option help.");
        options5.addOption(OptionBuilder.create((String)"help"));
        return options;
    }

    public void run(String[] args) throws IOException, URISyntaxException {
        if (!this.parseArguments(args)) {
            return;
        }
        this.start();
        this.sleepForever();
    }

    private void sleepForever() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start() throws IOException, FileNotFoundException, URISyntaxException {
        if (!this.noDFS) {
            this.dfs = new MiniDFSCluster.Builder((Configuration)this.conf).nameNodePort(this.nnPort).numDataNodes(this.numDataNodes).startupOption(this.dfsOpts).build();
            LOG.info((Object)("Started MiniDFSCluster -- namenode on port " + this.dfs.getNameNodePort()));
        }
        if (!this.noMR) {
            if (this.fs == null && this.dfs != null) {
                this.fs = this.dfs.getFileSystem().getUri().toString();
            } else if (this.fs == null) {
                this.fs = "file:///tmp/minimr-" + System.nanoTime();
            }
            FileSystem.setDefaultUri((Configuration)this.conf, (URI)new URI(this.fs));
            this.conf.setBoolean("yarn.minicluster.fixed.ports", true);
            this.conf.setBoolean("mapreduce.jobhistory.minicluster.fixed.ports", true);
            this.conf.set("yarn.resourcemanager.address", MiniYARNCluster.getHostname() + ":" + this.rmPort);
            this.conf.set("mapreduce.jobhistory.address", MiniYARNCluster.getHostname() + ":" + this.jhsPort);
            this.mr = MiniMRClientClusterFactory.create(this.getClass(), this.numNodeManagers, (Configuration)this.conf);
            LOG.info((Object)"Started MiniMRCluster");
        }
        if (this.writeConfig != null) {
            FileOutputStream fos = new FileOutputStream(new File(this.writeConfig));
            this.conf.writeXml((OutputStream)fos);
            fos.close();
        }
        if (this.writeDetails != null) {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            if (this.dfs != null) {
                map.put("namenode_port", this.dfs.getNameNodePort());
            }
            if (this.mr != null) {
                map.put("resourcemanager_port", this.mr.getConfig().get("yarn.resourcemanager.address").split(":")[1]);
            }
            FileWriter fw = new FileWriter(new File(this.writeDetails));
            fw.write(new JSON().toJSON(map));
            fw.close();
        }
    }

    public void stop() throws IOException {
        if (this.mr != null) {
            this.mr.stop();
        }
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
    }

    private boolean parseArguments(String[] args) {
        String[] stringArray;
        int n;
        int n2;
        CommandLine cli;
        Options options = this.makeOptions();
        try {
            GnuParser parser = new GnuParser();
            cli = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.warn((Object)("options parsing failed:  " + e.getMessage()));
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        if (cli.hasOption("help")) {
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        if (cli.getArgs().length > 0 && (n2 = 0) < (n = (stringArray = cli.getArgs()).length)) {
            String arg = stringArray[n2];
            System.err.println("Unrecognized option: " + arg);
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        this.noMR = cli.hasOption("nomr");
        this.numNodeManagers = this.intArgument(cli, "nodemanagers", 1);
        this.rmPort = this.intArgument(cli, "rmport", 0);
        this.jhsPort = this.intArgument(cli, "jhsport", 0);
        this.fs = cli.getOptionValue("namenode");
        this.noDFS = cli.hasOption("nodfs");
        this.numDataNodes = this.intArgument(cli, "datanodes", 1);
        this.nnPort = this.intArgument(cli, "nnport", 0);
        this.dfsOpts = cli.hasOption("format") ? HdfsServerConstants.StartupOption.FORMAT : HdfsServerConstants.StartupOption.REGULAR;
        this.writeDetails = cli.getOptionValue("writeDetails");
        this.writeConfig = cli.getOptionValue("writeConfig");
        this.conf = new JobConf();
        this.updateConfiguration(this.conf, cli.getOptionValues("D"));
        return true;
    }

    private void updateConfiguration(JobConf conf, String[] keyvalues) {
        int num_confs_updated = 0;
        if (keyvalues != null) {
            for (String prop : keyvalues) {
                String[] keyval = prop.split("=", 2);
                if (keyval.length == 2) {
                    conf.set(keyval[0], keyval[1]);
                    ++num_confs_updated;
                    continue;
                }
                LOG.warn((Object)("Ignoring -D option " + prop));
            }
        }
        LOG.info((Object)("Updated " + num_confs_updated + " configuration settings from command line."));
    }

    private int intArgument(CommandLine cli, String argName, int default_) {
        String o = cli.getOptionValue(argName);
        if (o == null) {
            return default_;
        }
        return Integer.parseInt(o);
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        new MiniHadoopClusterManager().run(args);
    }
}

