/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.buffer;

import org.python.netty.buffer.PoolArena;
import org.python.netty.buffer.PoolChunk;
import org.python.netty.buffer.PooledByteBuf;
import org.python.netty.util.internal.StringUtil;

final class PoolChunkList<T> {
    private final PoolArena<T> arena;
    private final PoolChunkList<T> nextList;
    PoolChunkList<T> prevList;
    private final int minUsage;
    private final int maxUsage;
    private PoolChunk<T> head;

    PoolChunkList(PoolArena<T> arena, PoolChunkList<T> nextList, int minUsage, int maxUsage) {
        this.arena = arena;
        this.nextList = nextList;
        this.minUsage = minUsage;
        this.maxUsage = maxUsage;
    }

    boolean allocate(PooledByteBuf<T> buf, int reqCapacity, int normCapacity) {
        long handle;
        if (this.head == null) {
            return false;
        }
        PoolChunk<T> cur = this.head;
        while ((handle = cur.allocate(normCapacity)) < 0L) {
            cur = cur.next;
            if (cur != null) continue;
            return false;
        }
        cur.initBuf(buf, handle, reqCapacity);
        if (cur.usage() >= this.maxUsage) {
            this.remove(cur);
            this.nextList.add(cur);
        }
        return true;
    }

    void free(PoolChunk<T> chunk2, long handle) {
        chunk2.free(handle);
        if (chunk2.usage() < this.minUsage) {
            this.remove(chunk2);
            if (this.prevList == null) {
                assert (chunk2.usage() == 0);
                this.arena.destroyChunk(chunk2);
            } else {
                this.prevList.add(chunk2);
            }
        }
    }

    void add(PoolChunk<T> chunk2) {
        if (chunk2.usage() >= this.maxUsage) {
            this.nextList.add(chunk2);
            return;
        }
        chunk2.parent = this;
        if (this.head == null) {
            this.head = chunk2;
            chunk2.prev = null;
            chunk2.next = null;
        } else {
            chunk2.prev = null;
            chunk2.next = this.head;
            this.head.prev = chunk2;
            this.head = chunk2;
        }
    }

    private void remove(PoolChunk<T> cur) {
        if (cur == this.head) {
            this.head = cur.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            PoolChunk next;
            cur.prev.next = next = cur.next;
            if (next != null) {
                next.prev = cur.prev;
            }
        }
    }

    public String toString() {
        if (this.head == null) {
            return "none";
        }
        StringBuilder buf = new StringBuilder();
        PoolChunk<T> cur = this.head;
        while (true) {
            buf.append(cur);
            cur = cur.next;
            if (cur == null) break;
            buf.append(StringUtil.NEWLINE);
        }
        return buf.toString();
    }
}

