/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.optimizer;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NoopFilterRemoverUtil;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class NoopFilterRemover
extends SparkOpPlanVisitor {
    private Log log = LogFactory.getLog(NoopFilterRemover.class);

    public NoopFilterRemover(SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DependencyOrderWalker<SparkOperator, SparkOperPlan>(plan));
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        LinkedList<POFilter> filters = PlanHelper.getPhysicalOperators(sparkOp.physicalPlan, POFilter.class);
        for (POFilter filter : filters) {
            Boolean filterValue;
            ConstantExpression exp;
            Object value;
            PhysicalOperator fp;
            PhysicalPlan filterPlan = filter.getPlan();
            if (filterPlan.size() != 1 || !((fp = (PhysicalOperator)filterPlan.getRoots().get(0)) instanceof ConstantExpression) || !((value = (exp = (ConstantExpression)fp).getValue()) instanceof Boolean) || !(filterValue = (Boolean)value).booleanValue()) continue;
            NoopFilterRemoverUtil.removeFilter(filter, sparkOp.physicalPlan);
        }
    }
}

