/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.List;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.UDFContext;

public class POReservoirSample
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    protected long numSamples;
    private transient int nextSampleIdx = 0;
    private transient long rowProcessed = 0L;
    private transient boolean sampleCollectionDone = false;
    private transient Result[] samples = null;
    private transient Result lastSample = null;
    private transient RandomDataGenerator randGen;

    public POReservoirSample(OperatorKey k) {
        this(k, -1, null);
    }

    public POReservoirSample(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POReservoirSample(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POReservoirSample(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public POReservoirSample(OperatorKey k, int rp, List<PhysicalOperator> inp, long numSamples) {
        super(k, rp, inp);
        this.numSamples = numSamples;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitReservoirSample(this);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (this.sampleCollectionDone) {
            return this.getSample();
        }
        if (this.samples == null) {
            this.samples = new Result[(int)this.numSamples];
            long taskIdHashCode = UDFContext.getUDFContext().getJobConf().get("mapreduce.task.id").hashCode();
            long randomSeed = taskIdHashCode << 32 | taskIdHashCode & 0xFFFFFFFFL;
            this.randGen = new RandomDataGenerator();
            this.randGen.reSeed(randomSeed);
        }
        Result res = null;
        while (this.rowProcessed < this.numSamples) {
            res = this.processInput();
            if (res.returnStatus == 2) {
                return res;
            }
            if (res.returnStatus == 0) {
                this.samples[(int)this.rowProcessed] = res;
                ++this.rowProcessed;
                continue;
            }
            if (res.returnStatus == 1) continue;
            if (res.returnStatus != 3 || this.parentPlan.endOfAllInput) break;
            return res;
        }
        if (res == null || res.returnStatus != 3) {
            while (true) {
                res = this.processInput();
                if (res.returnStatus == 2) {
                    return res;
                }
                if (res.returnStatus == 1) continue;
                if (res.returnStatus != 0) break;
                long rand = this.randGen.nextLong(0L, this.rowProcessed + 1L);
                if (rand < this.numSamples) {
                    this.samples[(int)rand] = res;
                }
                ++this.rowProcessed;
            }
        }
        if (res.returnStatus == 3) {
            if (this.parentPlan.endOfAllInput) {
                this.sampleCollectionDone = true;
            } else {
                return res;
            }
        }
        return this.getSample();
    }

    private Result getSample() throws ExecException {
        if (this.lastSample == null) {
            this.lastSample = this.retrieveSample();
        }
        if (this.lastSample.returnStatus == 3) {
            return this.lastSample;
        }
        Result currentSample = this.retrieveSample();
        if (currentSample.returnStatus == 3) {
            this.lastSample = this.createNumRowTuple((Tuple)this.lastSample.result);
        } else if (currentSample.returnStatus == 1) {
            return currentSample;
        }
        Result result = this.lastSample;
        this.lastSample = currentSample;
        return result;
    }

    private Result retrieveSample() throws ExecException {
        if ((long)this.nextSampleIdx < Math.min(this.rowProcessed, (long)this.samples.length)) {
            if (this.illustrator != null) {
                this.illustratorMarkup(this.samples[this.nextSampleIdx].result, this.samples[this.nextSampleIdx].result, 0);
            }
            Result res = this.samples[this.nextSampleIdx];
            this.samples[this.nextSampleIdx++] = null;
            if (res == null) {
                return RESULT_EMPTY;
            }
            return res;
        }
        this.samples = null;
        return RESULT_EOP;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return this.getAliasString() + "ReservoirSample - " + this.mKey.toString();
    }

    private Result createNumRowTuple(Tuple sample) throws ExecException {
        int sz = sample == null ? 0 : sample.size();
        Tuple t = mTupleFactory.newTuple(sz + 2);
        if (sample != null) {
            for (int i = 0; i < sample.size(); ++i) {
                t.set(i, sample.get(i));
            }
        }
        t.set(sz, "\u4956\u3838_pig_inTeRnal-spEcial_roW_num_tuple3kt579CFLehkblah");
        t.set(sz + 1, this.rowProcessed);
        return new Result(0, t);
    }
}

