/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.AbstractTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;

public class TargetedTuple
extends AbstractTuple {
    private static final long serialVersionUID = 2L;
    private Tuple t;
    public List<OperatorKey> targetOps = null;
    protected boolean isNull = false;

    public TargetedTuple() {
    }

    public TargetedTuple(Tuple t, List<OperatorKey> targetOps) {
        this.t = t;
        this.targetOps = targetOps;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[");
        for (OperatorKey target : this.targetOps) {
            sb.append(target.toString());
            sb.append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), "]");
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        this.t.write(out);
        out.writeInt(this.targetOps.size());
        for (OperatorKey target : this.targetOps) {
            out.writeInt(target.scope.length());
            out.writeBytes(target.scope);
            out.writeLong(target.id);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.t.readFields(in);
        this.targetOps = new ArrayList<OperatorKey>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            OperatorKey target = new OperatorKey();
            int scopeSz = in.readInt();
            byte[] buf = new byte[scopeSz];
            in.readFully(buf);
            target.scope = new String(buf);
            target.id = in.readLong();
            this.targetOps.add(target);
        }
    }

    public Tuple toTuple() {
        return this.t;
    }

    public List<OperatorKey> getTargetOps() {
        return this.targetOps;
    }

    public void setTargetOps(List<OperatorKey> targetOps) {
        this.targetOps = targetOps;
    }

    @Override
    public void append(Object val) {
        this.t.append(val);
    }

    @Override
    public Object get(int fieldNum) throws ExecException {
        return this.t.get(fieldNum);
    }

    @Override
    public List<Object> getAll() {
        return this.t.getAll();
    }

    @Override
    public long getMemorySize() {
        return this.t.getMemorySize();
    }

    @Override
    public byte getType(int fieldNum) throws ExecException {
        return this.t.getType(fieldNum);
    }

    @Override
    public void reference(Tuple t) {
        this.t = t;
    }

    @Override
    public void set(int fieldNum, Object val) throws ExecException {
        this.t.set(fieldNum, val);
    }

    @Override
    public int size() {
        return this.t.size();
    }

    public int compareTo(Object o) {
        return this.t.compareTo(o);
    }

    @Override
    public boolean equals(Object o) {
        return this.t.equals(o);
    }

    public int hashCode() {
        return this.t.hashCode();
    }
}

