/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractAppendTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractAppendTest.class);
    private Path testPath;
    private Path target;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.skipIfUnsupported("supports-append");
        this.testPath = this.path("test");
        this.target = new Path(this.testPath, "target");
    }

    @Test
    public void testAppendToEmptyFile() throws Throwable {
        ContractTestUtils.touch(this.getFileSystem(), this.target);
        byte[] dataset = ContractTestUtils.dataset(256, 97, 122);
        try (FSDataOutputStream outputStream = this.getFileSystem().append(this.target);){
            outputStream.write(dataset);
        }
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), this.target, dataset.length);
        ContractTestUtils.compareByteArrays(dataset, bytes, dataset.length);
    }

    @Test
    public void testBuilderAppendToEmptyFile() throws Throwable {
        ContractTestUtils.touch(this.getFileSystem(), this.target);
        byte[] dataset = ContractTestUtils.dataset(256, 97, 122);
        try (FSDataOutputStream outputStream = this.getFileSystem().appendFile(this.target).build();){
            outputStream.write(dataset);
        }
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), this.target, dataset.length);
        ContractTestUtils.compareByteArrays(dataset, bytes, dataset.length);
    }

    @Test
    public void testAppendNonexistentFile() throws Throwable {
        try {
            FSDataOutputStream out = this.getFileSystem().append(this.target);
            out.close();
            AbstractContractAppendTest.fail((String)"expected a failure");
        }
        catch (Exception e) {
            this.handleExpectedException(e);
        }
    }

    @Test
    public void testAppendToExistingFile() throws Throwable {
        byte[] original = ContractTestUtils.dataset(8192, 65, 90);
        byte[] appended = ContractTestUtils.dataset(8192, 48, 57);
        ContractTestUtils.createFile(this.getFileSystem(), this.target, false, original);
        try (FSDataOutputStream out = this.getFileSystem().append(this.target);){
            out.write(appended);
        }
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), this.target, original.length + appended.length);
        ContractTestUtils.validateFileContent(bytes, new byte[][]{original, appended});
    }

    @Test
    public void testBuilderAppendToExistingFile() throws Throwable {
        byte[] original = ContractTestUtils.dataset(8192, 65, 90);
        byte[] appended = ContractTestUtils.dataset(8192, 48, 57);
        ContractTestUtils.createFile(this.getFileSystem(), this.target, false, original);
        try (FSDataOutputStream out = this.getFileSystem().appendFile(this.target).build();){
            out.write(appended);
        }
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), this.target, original.length + appended.length);
        ContractTestUtils.validateFileContent(bytes, new byte[][]{original, appended});
    }

    @Test
    public void testAppendMissingTarget() throws Throwable {
        try {
            FSDataOutputStream out = this.getFileSystem().append(this.target);
            out.close();
            AbstractContractAppendTest.fail((String)"expected a failure");
        }
        catch (Exception e) {
            this.handleExpectedException(e);
        }
    }

    @Test
    public void testRenameFileBeingAppended() throws Throwable {
        ContractTestUtils.touch(this.getFileSystem(), this.target);
        this.assertPathExists("original file does not exist", this.target);
        byte[] dataset = ContractTestUtils.dataset(256, 97, 122);
        FSDataOutputStream outputStream = this.getFileSystem().append(this.target);
        if (this.isSupported("create-visibility-delayed")) {
            Thread.sleep(100L);
        }
        outputStream.write(dataset);
        Path renamed = new Path(this.testPath, "renamed");
        this.rename(this.target, renamed);
        outputStream.close();
        String listing = this.ls(this.testPath);
        this.assertPathExists("renamed destination file does not exist", renamed);
        this.assertPathDoesNotExist("Source file found after rename during append:\n" + listing, this.target);
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), renamed, dataset.length);
        ContractTestUtils.compareByteArrays(dataset, bytes, dataset.length);
    }
}

