/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.TestConnectionRetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.ipc.TestRpcBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReuseRpcConnections
extends TestRpcBase {
    @Before
    public void setup() {
        this.setupConf();
    }

    private static RetryPolicy getDefaultRetryPolicy(boolean defaultRetryPolicyEnabled, String defaultRetryPolicySpec) {
        return TestConnectionRetryPolicy.getDefaultRetryPolicy(conf, defaultRetryPolicyEnabled, defaultRetryPolicySpec, "");
    }

    private static RetryPolicy getDefaultRetryPolicy(boolean defaultRetryPolicyEnabled, String defaultRetryPolicySpec, String remoteExceptionToRetry) {
        return TestConnectionRetryPolicy.getDefaultRetryPolicy(conf, defaultRetryPolicyEnabled, defaultRetryPolicySpec, remoteExceptionToRetry);
    }

    @Test(timeout=60000L)
    public void testDefaultRetryPolicyReuseConnections() throws Exception {
        RetryPolicy rp1 = null;
        RetryPolicy rp2 = null;
        RetryPolicy rp3 = null;
        rp1 = TestReuseRpcConnections.getDefaultRetryPolicy(true, "10000,2");
        rp2 = TestReuseRpcConnections.getDefaultRetryPolicy(true, "10000,2");
        this.verifyRetryPolicyReuseConnections(rp1, rp2, RetryPolicies.RETRY_FOREVER);
        rp1 = TestReuseRpcConnections.getDefaultRetryPolicy(true, "20000,3");
        rp2 = TestReuseRpcConnections.getDefaultRetryPolicy(true, "20000,3");
        rp3 = TestReuseRpcConnections.getDefaultRetryPolicy(true, "30000,4");
        this.verifyRetryPolicyReuseConnections(rp1, rp2, rp3);
        rp1 = TestReuseRpcConnections.getDefaultRetryPolicy(false, "40000,5");
        rp2 = TestReuseRpcConnections.getDefaultRetryPolicy(false, "40000,5");
        this.verifyRetryPolicyReuseConnections(rp1, rp2, RetryPolicies.RETRY_FOREVER);
        rp1 = TestReuseRpcConnections.getDefaultRetryPolicy(false, "50000,6");
        rp2 = TestReuseRpcConnections.getDefaultRetryPolicy(false, "60000,7");
        this.verifyRetryPolicyReuseConnections(rp1, rp2, RetryPolicies.RETRY_FOREVER);
        rp1 = TestReuseRpcConnections.getDefaultRetryPolicy(true, "70000,8", new RemoteException(RpcNoSuchMethodException.class.getName(), "no such method exception").getClassName());
        rp2 = TestReuseRpcConnections.getDefaultRetryPolicy(true, "70000,8", new RemoteException(PathIOException.class.getName(), "path IO exception").getClassName());
        this.verifyRetryPolicyReuseConnections(rp1, rp2, RetryPolicies.RETRY_FOREVER);
    }

    @Test(timeout=60000L)
    public void testRetryPolicyTryOnceThenFail() throws Exception {
        RetryPolicy rp1 = TestConnectionRetryPolicy.newTryOnceThenFail();
        RetryPolicy rp2 = TestConnectionRetryPolicy.newTryOnceThenFail();
        this.verifyRetryPolicyReuseConnections(rp1, rp2, RetryPolicies.RETRY_FOREVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRetryPolicyReuseConnections(RetryPolicy retryPolicy1, RetryPolicy retryPolicy2, RetryPolicy anotherRetryPolicy) throws Exception {
        RPC.Server server = TestReuseRpcConnections.setupTestServer(conf, 2);
        Configuration newConf = new Configuration(conf);
        newConf.set("hadoop.rpc.socket.factory.class.default", "");
        Client client = null;
        TestRpcBase.TestRpcService proxy1 = null;
        TestRpcBase.TestRpcService proxy2 = null;
        TestRpcBase.TestRpcService proxy3 = null;
        try {
            proxy1 = TestReuseRpcConnections.getClient(addr, newConf, retryPolicy1);
            proxy1.ping(null, TestReuseRpcConnections.newEmptyRequest());
            client = ProtobufRpcEngine.getClient((Configuration)newConf);
            Set conns = client.getConnectionIds();
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)1L, (long)conns.size());
            proxy2 = TestReuseRpcConnections.getClient(addr, newConf, retryPolicy2);
            proxy2.ping(null, TestReuseRpcConnections.newEmptyRequest());
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)1L, (long)conns.size());
            proxy3 = TestReuseRpcConnections.getClient(addr, newConf, anotherRetryPolicy);
            proxy3.ping(null, TestReuseRpcConnections.newEmptyRequest());
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)2L, (long)conns.size());
        }
        catch (Throwable throwable) {
            server.stop();
            if (client != null) {
                client.getConnectionIds().clear();
            }
            if (proxy1 != null) {
                RPC.stopProxy((Object)proxy1);
            }
            if (proxy2 != null) {
                RPC.stopProxy(proxy2);
            }
            if (proxy3 != null) {
                RPC.stopProxy(proxy3);
            }
            throw throwable;
        }
        server.stop();
        if (client != null) {
            client.getConnectionIds().clear();
        }
        if (proxy1 != null) {
            RPC.stopProxy((Object)proxy1);
        }
        if (proxy2 != null) {
            RPC.stopProxy((Object)proxy2);
        }
        if (proxy3 != null) {
            RPC.stopProxy((Object)proxy3);
        }
    }
}

