/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClassFinder;
import org.apache.hadoop.hbase.ClassTestFinder;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestInterfaceAudienceAnnotations {
    private static final Log LOG = LogFactory.getLog(TestInterfaceAudienceAnnotations.class);

    private boolean isInterfaceAudienceClass(Class<?> c) {
        return c.equals(InterfaceAudience.Public.class) || c.equals(InterfaceAudience.Private.class) || c.equals(InterfaceAudience.LimitedPrivate.class);
    }

    private boolean isInterfaceStabilityClass(Class<?> c) {
        return c.equals(InterfaceStability.Stable.class) || c.equals(InterfaceStability.Unstable.class) || c.equals(InterfaceStability.Evolving.class);
    }

    @Test
    public void testInterfaceAudienceAnnotation() throws ClassNotFoundException, IOException, LinkageError {
        ClassFinder classFinder = new ClassFinder((ClassFinder.ResourcePathFilter)new ClassFinder.And(new ClassFinder.ResourcePathFilter[]{new MainCodeResourcePathFilter(), new ClassTestFinder.TestFileNameFilter()}), (ClassFinder.FileNameFilter)new ClassFinder.Not((ClassFinder.FileNameFilter)new ClassTestFinder.TestFileNameFilter()), (ClassFinder.ClassFilter)new ClassFinder.And(new ClassFinder.ClassFilter[]{new PublicClassFilter(), new ClassFinder.Not((ClassFinder.ClassFilter)new ClassTestFinder.TestClassFilter()), new ClassFinder.Not((ClassFinder.ClassFilter)new GeneratedClassFilter()), new ClassFinder.Not((ClassFinder.ClassFilter)new IsInterfaceStabilityClassFilter()), new ClassFinder.Not((ClassFinder.ClassFilter)new InterfaceAudienceAnnotatedClassFilter()), new ClassFinder.Not((ClassFinder.ClassFilter)new CloverInstrumentationFilter())}));
        Set classes = classFinder.findClasses(false);
        LOG.info((Object)"These are the classes that DO NOT have @InterfaceAudience annotation:");
        for (Class clazz : classes) {
            LOG.info((Object)clazz);
        }
        Assert.assertEquals((String)"All classes should have @InterfaceAudience annotation", (long)0L, (long)classes.size());
    }

    @Test
    public void testInterfaceStabilityAnnotation() throws ClassNotFoundException, IOException, LinkageError {
        ClassFinder classFinder = new ClassFinder((ClassFinder.ResourcePathFilter)new ClassFinder.And(new ClassFinder.ResourcePathFilter[]{new MainCodeResourcePathFilter(), new ClassTestFinder.TestFileNameFilter()}), (ClassFinder.FileNameFilter)new ClassFinder.Not((ClassFinder.FileNameFilter)new ClassTestFinder.TestFileNameFilter()), (ClassFinder.ClassFilter)new ClassFinder.And(new ClassFinder.ClassFilter[]{new PublicClassFilter(), new ClassFinder.Not((ClassFinder.ClassFilter)new ClassTestFinder.TestClassFilter()), new ClassFinder.Not((ClassFinder.ClassFilter)new GeneratedClassFilter()), new InterfaceAudiencePublicAnnotatedClassFilter(), new ClassFinder.Not((ClassFinder.ClassFilter)new IsInterfaceStabilityClassFilter()), new ClassFinder.Not((ClassFinder.ClassFilter)new InterfaceStabilityAnnotatedClassFilter())}));
        Set classes = classFinder.findClasses(false);
        LOG.info((Object)"These are the classes that DO NOT have @InterfaceStability annotation:");
        for (Class clazz : classes) {
            LOG.info((Object)clazz);
        }
        Assert.assertEquals((String)"All classes that are marked with @InterfaceAudience.Public should have @InterfaceStability annotation as well", (long)0L, (long)classes.size());
    }

    class CloverInstrumentationFilter
    implements ClassFinder.ClassFilter {
        CloverInstrumentationFilter() {
        }

        public boolean isCandidateClass(Class<?> clazz) {
            boolean clover = false;
            Class<?> enclosing = clazz.getEnclosingClass();
            if (enclosing != null && !enclosing.isInterface()) {
                clover = clazz.getSimpleName().startsWith("__CLR");
            }
            return clover;
        }
    }

    class MainCodeResourcePathFilter
    implements ClassFinder.ResourcePathFilter {
        MainCodeResourcePathFilter() {
        }

        public boolean isCandidatePath(String resourcePath, boolean isJar) {
            return !resourcePath.contains("test-classes") && !resourcePath.contains("tests.jar");
        }
    }

    class PublicClassFilter
    implements ClassFinder.ClassFilter {
        PublicClassFilter() {
        }

        public boolean isCandidateClass(Class<?> c) {
            int mod = c.getModifiers();
            return Modifier.isPublic(mod);
        }
    }

    class IsInterfaceStabilityClassFilter
    implements ClassFinder.ClassFilter {
        IsInterfaceStabilityClassFilter() {
        }

        public boolean isCandidateClass(Class<?> c) {
            return TestInterfaceAudienceAnnotations.this.isInterfaceAudienceClass(c) || TestInterfaceAudienceAnnotations.this.isInterfaceStabilityClass(c);
        }
    }

    class InterfaceAudiencePublicAnnotatedClassFilter
    extends InterfaceAudienceAnnotatedClassFilter {
        InterfaceAudiencePublicAnnotatedClassFilter() {
        }

        @Override
        public boolean isCandidateClass(Class<?> c) {
            return InterfaceAudience.Public.class.equals(this.getAnnotation(c));
        }
    }

    class InterfaceStabilityAnnotatedClassFilter
    implements ClassFinder.ClassFilter {
        InterfaceStabilityAnnotatedClassFilter() {
        }

        public boolean isCandidateClass(Class<?> c) {
            return this.getAnnotation(c) != null;
        }

        protected Class<?> getAnnotation(Class<?> c) {
            Annotation[] anns;
            for (Annotation ann : anns = c.getDeclaredAnnotations()) {
                Class<? extends Annotation> type = ann.annotationType();
                if (!TestInterfaceAudienceAnnotations.this.isInterfaceStabilityClass(type)) continue;
                return type;
            }
            return null;
        }
    }

    class InterfaceAudienceAnnotatedClassFilter
    implements ClassFinder.ClassFilter {
        InterfaceAudienceAnnotatedClassFilter() {
        }

        public boolean isCandidateClass(Class<?> c) {
            if (this.getAnnotation(c) != null) {
                return true;
            }
            return this.isAnnotatedPrivate(c.getEnclosingClass());
        }

        private boolean isAnnotatedPrivate(Class<?> c) {
            if (c == null) {
                return false;
            }
            Class<?> ann = this.getAnnotation(c);
            if (ann != null && !InterfaceAudience.Public.class.equals(ann)) {
                return true;
            }
            return this.isAnnotatedPrivate(c.getEnclosingClass());
        }

        protected Class<?> getAnnotation(Class<?> c) {
            Annotation[] anns;
            for (Annotation ann : anns = c.getDeclaredAnnotations()) {
                Class<? extends Annotation> type = ann.annotationType();
                if (!TestInterfaceAudienceAnnotations.this.isInterfaceAudienceClass(type)) continue;
                return type;
            }
            return null;
        }
    }

    class GeneratedClassFilter
    implements ClassFinder.ClassFilter {
        GeneratedClassFilter() {
        }

        public boolean isCandidateClass(Class<?> c) {
            return c.getPackage().getName().contains("generated");
        }
    }
}

