/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestDrainingServer {
    private static final Log LOG = LogFactory.getLog(TestDrainingServer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Abortable abortable = new Abortable(){

        public boolean isAborted() {
            return false;
        }

        public void abort(String why, Throwable e) {
        }
    };

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        TEST_UTIL.startMiniZKCluster();
    }

    @Test
    public void testAssignmentManagerDoesntUseDrainingServer() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        HMaster master = (HMaster)Mockito.mock(HMaster.class);
        MasterServices server = (MasterServices)Mockito.mock(MasterServices.class);
        ServerManager serverManager = (ServerManager)Mockito.mock(ServerManager.class);
        ServerName SERVERNAME_A = ServerName.valueOf((String)"mockserver_a.org", (int)1000, (long)8000L);
        ServerName SERVERNAME_B = ServerName.valueOf((String)"mockserver_b.org", (int)1001, (long)8000L);
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)conf);
        HRegionInfo REGIONINFO = new HRegionInfo(TableName.valueOf((String)"table_test"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        ZooKeeperWatcher zkWatcher = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "zkWatcher-Test", this.abortable, true);
        HashMap<ServerName, ServerLoad> onlineServers = new HashMap<ServerName, ServerLoad>();
        onlineServers.put(SERVERNAME_A, ServerLoad.EMPTY_SERVERLOAD);
        onlineServers.put(SERVERNAME_B, ServerLoad.EMPTY_SERVERLOAD);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)server.getServerName()).thenReturn((Object)ServerName.valueOf((String)"masterMock,1,1"));
        Mockito.when((Object)server.getZooKeeper()).thenReturn((Object)zkWatcher);
        ZkCoordinatedStateManager cp = new ZkCoordinatedStateManager();
        cp.initialize((Server)server);
        cp.start();
        Mockito.when((Object)server.getCoordinatedStateManager()).thenReturn((Object)cp);
        Mockito.when((Object)serverManager.getOnlineServers()).thenReturn(onlineServers);
        Mockito.when((Object)serverManager.getOnlineServersList()).thenReturn(new ArrayList(onlineServers.keySet()));
        Mockito.when((Object)serverManager.createDestinationServersList()).thenReturn(new ArrayList(onlineServers.keySet()));
        Mockito.when((Object)serverManager.createDestinationServersList(null)).thenReturn(new ArrayList(onlineServers.keySet()));
        for (ServerName sn : onlineServers.keySet()) {
            Mockito.when((Object)serverManager.isServerOnline(sn)).thenReturn((Object)true);
            Mockito.when((Object)serverManager.sendRegionClose(sn, REGIONINFO, -1)).thenReturn((Object)true);
            Mockito.when((Object)serverManager.sendRegionClose(sn, REGIONINFO, -1, null, false)).thenReturn((Object)true);
            Mockito.when((Object)serverManager.sendRegionOpen(sn, REGIONINFO, -1, new ArrayList())).thenReturn((Object)RegionOpeningState.OPENED);
            Mockito.when((Object)serverManager.sendRegionOpen(sn, REGIONINFO, -1, null)).thenReturn((Object)RegionOpeningState.OPENED);
            Mockito.when((Object)serverManager.addServerToDrainList(sn)).thenReturn((Object)true);
        }
        Mockito.when((Object)master.getServerManager()).thenReturn((Object)serverManager);
        AssignmentManager am = new AssignmentManager(server, serverManager, balancer, this.startupMasterExecutor("mockExecutorService"), null, null);
        Mockito.when((Object)master.getAssignmentManager()).thenReturn((Object)am);
        Mockito.when((Object)master.getZooKeeper()).thenReturn((Object)zkWatcher);
        am.addPlan(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_A));
        zkWatcher.registerListenerFirst((ZooKeeperListener)am);
        this.addServerToDrainedList(SERVERNAME_A, onlineServers, serverManager);
        am.assign(REGIONINFO, true);
        this.setRegionOpenedOnZK(zkWatcher, SERVERNAME_A, REGIONINFO);
        this.setRegionOpenedOnZK(zkWatcher, SERVERNAME_B, REGIONINFO);
        am.waitForAssignment(REGIONINFO);
        Assert.assertTrue((boolean)am.getRegionStates().isRegionOnline(REGIONINFO));
        Assert.assertNotEquals((Object)am.getRegionStates().getRegionServerOfRegion(REGIONINFO), (Object)SERVERNAME_A);
    }

    @Test
    public void testAssignmentManagerDoesntUseDrainedServerWithBulkAssign() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)conf);
        HMaster master = (HMaster)Mockito.mock(HMaster.class);
        MasterServices server = (MasterServices)Mockito.mock(MasterServices.class);
        ServerManager serverManager = (ServerManager)Mockito.mock(ServerManager.class);
        ServerName SERVERNAME_A = ServerName.valueOf((String)"mockserverbulk_a.org", (int)1000, (long)8000L);
        ServerName SERVERNAME_B = ServerName.valueOf((String)"mockserverbulk_b.org", (int)1001, (long)8000L);
        ServerName SERVERNAME_C = ServerName.valueOf((String)"mockserverbulk_c.org", (int)1002, (long)8000L);
        ServerName SERVERNAME_D = ServerName.valueOf((String)"mockserverbulk_d.org", (int)1003, (long)8000L);
        ServerName SERVERNAME_E = ServerName.valueOf((String)"mockserverbulk_e.org", (int)1004, (long)8000L);
        HashMap<HRegionInfo, ServerName> bulk = new HashMap<HRegionInfo, ServerName>();
        HashSet bunchServersAssigned = new HashSet();
        HRegionInfo REGIONINFO_A = new HRegionInfo(TableName.valueOf((String)"table_A"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        HRegionInfo REGIONINFO_B = new HRegionInfo(TableName.valueOf((String)"table_B"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        HRegionInfo REGIONINFO_C = new HRegionInfo(TableName.valueOf((String)"table_C"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        HRegionInfo REGIONINFO_D = new HRegionInfo(TableName.valueOf((String)"table_D"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        HRegionInfo REGIONINFO_E = new HRegionInfo(TableName.valueOf((String)"table_E"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        HashMap<ServerName, ServerLoad> onlineServers = new HashMap<ServerName, ServerLoad>();
        ArrayList<ServerName> drainedServers = new ArrayList<ServerName>();
        onlineServers.put(SERVERNAME_A, ServerLoad.EMPTY_SERVERLOAD);
        onlineServers.put(SERVERNAME_B, ServerLoad.EMPTY_SERVERLOAD);
        onlineServers.put(SERVERNAME_C, ServerLoad.EMPTY_SERVERLOAD);
        onlineServers.put(SERVERNAME_D, ServerLoad.EMPTY_SERVERLOAD);
        onlineServers.put(SERVERNAME_E, ServerLoad.EMPTY_SERVERLOAD);
        bulk.put(REGIONINFO_A, SERVERNAME_A);
        bulk.put(REGIONINFO_B, SERVERNAME_B);
        bulk.put(REGIONINFO_C, SERVERNAME_C);
        bulk.put(REGIONINFO_D, SERVERNAME_D);
        bulk.put(REGIONINFO_E, SERVERNAME_E);
        ZooKeeperWatcher zkWatcher = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "zkWatcher-BulkAssignTest", this.abortable, true);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)server.getServerName()).thenReturn((Object)ServerName.valueOf((String)"masterMock,1,1"));
        Mockito.when((Object)server.getZooKeeper()).thenReturn((Object)zkWatcher);
        ZkCoordinatedStateManager cp = new ZkCoordinatedStateManager();
        cp.initialize((Server)server);
        cp.start();
        Mockito.when((Object)server.getCoordinatedStateManager()).thenReturn((Object)cp);
        Mockito.when((Object)serverManager.getOnlineServers()).thenReturn(onlineServers);
        Mockito.when((Object)serverManager.getOnlineServersList()).thenReturn(new ArrayList(onlineServers.keySet()));
        Mockito.when((Object)serverManager.createDestinationServersList()).thenReturn(new ArrayList(onlineServers.keySet()));
        Mockito.when((Object)serverManager.createDestinationServersList(null)).thenReturn(new ArrayList(onlineServers.keySet()));
        for (Map.Entry entry : bulk.entrySet()) {
            Mockito.when((Object)serverManager.isServerOnline((ServerName)entry.getValue())).thenReturn((Object)true);
            Mockito.when((Object)serverManager.sendRegionClose((ServerName)entry.getValue(), (HRegionInfo)entry.getKey(), -1)).thenReturn((Object)true);
            Mockito.when((Object)serverManager.sendRegionOpen((ServerName)entry.getValue(), (HRegionInfo)entry.getKey(), -1, null)).thenReturn((Object)RegionOpeningState.OPENED);
            Mockito.when((Object)serverManager.addServerToDrainList((ServerName)entry.getValue())).thenReturn((Object)true);
        }
        Mockito.when((Object)master.getServerManager()).thenReturn((Object)serverManager);
        drainedServers.add(SERVERNAME_A);
        drainedServers.add(SERVERNAME_B);
        drainedServers.add(SERVERNAME_C);
        drainedServers.add(SERVERNAME_D);
        AssignmentManager am = new AssignmentManager(server, serverManager, balancer, this.startupMasterExecutor("mockExecutorServiceBulk"), null, null);
        Mockito.when((Object)master.getAssignmentManager()).thenReturn((Object)am);
        zkWatcher.registerListener((ZooKeeperListener)am);
        for (ServerName drained : drainedServers) {
            this.addServerToDrainedList(drained, onlineServers, serverManager);
        }
        am.assign(bulk);
        Map regionsInTransition = am.getRegionStates().getRegionsInTransition();
        for (Map.Entry entry : regionsInTransition.entrySet()) {
            this.setRegionOpenedOnZK(zkWatcher, ((RegionState)entry.getValue()).getServerName(), ((RegionState)entry.getValue()).getRegion());
        }
        am.waitForAssignment(REGIONINFO_A);
        am.waitForAssignment(REGIONINFO_B);
        am.waitForAssignment(REGIONINFO_C);
        am.waitForAssignment(REGIONINFO_D);
        am.waitForAssignment(REGIONINFO_E);
        Map regionAssignments = am.getRegionStates().getRegionAssignments();
        for (Map.Entry entry : regionAssignments.entrySet()) {
            LOG.info((Object)("Region Assignment: " + ((HRegionInfo)entry.getKey()).getRegionNameAsString() + " Server: " + entry.getValue()));
            bunchServersAssigned.add(entry.getValue());
        }
        for (ServerName sn : drainedServers) {
            Assert.assertFalse((boolean)bunchServersAssigned.contains(sn));
        }
    }

    private void addServerToDrainedList(ServerName serverName, Map<ServerName, ServerLoad> onlineServers, ServerManager serverManager) {
        onlineServers.remove(serverName);
        ArrayList<ServerName> availableServers = new ArrayList<ServerName>(onlineServers.keySet());
        Mockito.when((Object)serverManager.createDestinationServersList()).thenReturn(availableServers);
        Mockito.when((Object)serverManager.createDestinationServersList(null)).thenReturn(availableServers);
    }

    private void setRegionOpenedOnZK(ZooKeeperWatcher zkWatcher, ServerName serverName, HRegionInfo hregionInfo) throws Exception {
        int version = ZKAssign.getVersion((ZooKeeperWatcher)zkWatcher, (HRegionInfo)hregionInfo);
        int versionTransition = ZKAssign.transitionNode((ZooKeeperWatcher)zkWatcher, (HRegionInfo)hregionInfo, (ServerName)serverName, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)version);
        ZKAssign.transitionNodeOpened((ZooKeeperWatcher)zkWatcher, (HRegionInfo)hregionInfo, (ServerName)serverName, (int)versionTransition);
    }

    private ExecutorService startupMasterExecutor(String name) {
        ExecutorService executor = new ExecutorService(name);
        executor.startExecutorService(ExecutorType.MASTER_OPEN_REGION, 3);
        executor.startExecutorService(ExecutorType.MASTER_CLOSE_REGION, 3);
        executor.startExecutorService(ExecutorType.MASTER_SERVER_OPERATIONS, 3);
        executor.startExecutorService(ExecutorType.MASTER_META_SERVER_OPERATIONS, 3);
        return executor;
    }
}

