/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.TestTableName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestCorruptedRegionStoreFile {
    private static final Log LOG = LogFactory.getLog(TestCorruptedRegionStoreFile.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final String FAMILY_NAME_STR = "f";
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"f");
    private static final int NUM_FILES = 10;
    private static final int ROW_PER_FILE = 2000;
    private static final int NUM_ROWS = 20000;
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private final ArrayList<Path> storeFiles = new ArrayList();
    private Path tableDir;
    private int rowCount;

    private static void setupConf(Configuration conf) {
        conf.setLong("hbase.hstore.compactionThreshold", 11L);
        conf.setLong("hbase.hstore.blockingStoreFiles", 20L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTable(final TableName tableName) throws IOException {
        HTable table = UTIL.createTable(tableName, FAMILY_NAME);
        try {
            this.rowCount = 0;
            byte[] value = new byte[1024];
            byte[] q = Bytes.toBytes((String)"q");
            while (this.rowCount < 20000) {
                Put put = new Put(Bytes.toBytes((String)String.format("%010d", this.rowCount)));
                put.setDurability(Durability.SKIP_WAL);
                put.add(FAMILY_NAME, q, value);
                table.put(put);
                if (this.rowCount++ % 2000 != 0) continue;
                table.flushCommits();
                UTIL.getHBaseAdmin().flush(tableName);
            }
        }
        finally {
            UTIL.getHBaseAdmin().flush(tableName);
            table.close();
        }
        Assert.assertEquals((long)20000L, (long)this.rowCount);
        this.storeFiles.clear();
        this.tableDir = FSUtils.getTableDir((Path)this.getRootDir(), (TableName)tableName);
        FSVisitor.visitTableStoreFiles((FileSystem)this.getFileSystem(), (Path)this.tableDir, (FSVisitor.StoreFileVisitor)new FSVisitor.StoreFileVisitor(){

            public void storeFile(String region, String family, String hfile) throws IOException {
                HFileLink link = HFileLink.build((Configuration)UTIL.getConfiguration(), (TableName)tableName, (String)region, (String)family, (String)hfile);
                TestCorruptedRegionStoreFile.this.storeFiles.add(link.getOriginPath());
            }
        });
        Assert.assertTrue((String)"Expected at least 10 store files", (this.storeFiles.size() >= 10 ? 1 : 0) != 0);
        LOG.info((Object)("Store files: " + this.storeFiles));
    }

    @Before
    public void setup() throws Exception {
        TestCorruptedRegionStoreFile.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2, 3);
        this.setupTable(this.TEST_TABLE.getTableName());
    }

    @After
    public void tearDown() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Test(timeout=180000L)
    public void testLosingFileDuringScan() throws Exception {
        Assert.assertEquals((long)this.rowCount, (long)this.fullScanAndCount(this.TEST_TABLE.getTableName()));
        final FileSystem fs = this.getFileSystem();
        final Path tmpStoreFilePath = new Path(UTIL.getDataTestDir(), "corruptedHFile");
        int count = this.fullScanAndCount(this.TEST_TABLE.getTableName(), new ScanInjector(){
            private boolean hasFile = true;

            @Override
            public void beforeScanNext(Table table) throws Exception {
                if (this.hasFile) {
                    fs.copyToLocalFile(true, (Path)TestCorruptedRegionStoreFile.this.storeFiles.get(0), tmpStoreFilePath);
                    LOG.info((Object)"Move file to local");
                    TestCorruptedRegionStoreFile.this.evictHFileCache((Path)TestCorruptedRegionStoreFile.this.storeFiles.get(0));
                    this.hasFile = false;
                }
            }
        });
        Assert.assertTrue((String)("expected one file lost: rowCount=" + count + " lostRows=" + (20000 - count)), (count >= 18000 ? 1 : 0) != 0);
    }

    @Test(timeout=180000L)
    public void testLosingFileAfterScannerInit() throws Exception {
        Assert.assertEquals((long)this.rowCount, (long)this.fullScanAndCount(this.TEST_TABLE.getTableName()));
        final FileSystem fs = this.getFileSystem();
        final Path tmpStoreFilePath = new Path(UTIL.getDataTestDir(), "corruptedHFile");
        int count = this.fullScanAndCount(this.TEST_TABLE.getTableName(), new ScanInjector(){
            private boolean hasFile = true;

            @Override
            public void beforeScan(Table table, Scan scan) throws Exception {
                if (this.hasFile) {
                    fs.copyToLocalFile(true, (Path)TestCorruptedRegionStoreFile.this.storeFiles.get(0), tmpStoreFilePath);
                    LOG.info((Object)"Move file to local");
                    TestCorruptedRegionStoreFile.this.evictHFileCache((Path)TestCorruptedRegionStoreFile.this.storeFiles.get(0));
                    this.hasFile = false;
                }
            }
        });
        Assert.assertTrue((String)("expected one file lost: rowCount=" + count + " lostRows=" + (20000 - count)), (count >= 18000 ? 1 : 0) != 0);
    }

    private FileSystem getFileSystem() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
    }

    private Path getRootDir() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }

    private void evictHFileCache(Path hfile) throws Exception {
        for (JVMClusterUtil.RegionServerThread rst : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer rs = rst.getRegionServer();
            rs.getCacheConfig().getBlockCache().evictBlocksByHfileName(hfile.getName());
        }
        Thread.sleep(6000L);
    }

    private int fullScanAndCount(TableName tableName) throws Exception {
        return this.fullScanAndCount(tableName, new ScanInjector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fullScanAndCount(TableName tableName, ScanInjector injector) throws Exception {
        int count = 0;
        try (Table table = UTIL.getConnection().getTable(tableName);){
            Scan scan = new Scan();
            scan.setCaching(1);
            scan.setCacheBlocks(false);
            injector.beforeScan(table, scan);
            ResultScanner scanner = table.getScanner(scan);
            try {
                while (true) {
                    injector.beforeScanNext(table);
                    Result result = scanner.next();
                    injector.afterScanNext(table, result);
                    if (result == null) {
                        break;
                    }
                    if (count++ % 1000 != 0) continue;
                    LOG.debug((Object)("scan next " + count));
                }
            }
            finally {
                scanner.close();
                injector.afterScan(table);
            }
        }
        return count;
    }

    private class ScanInjector {
        private ScanInjector() {
        }

        protected void beforeScan(Table table, Scan scan) throws Exception {
        }

        protected void beforeScanNext(Table table) throws Exception {
        }

        protected void afterScanNext(Table table, Result result) throws Exception {
        }

        protected void afterScan(Table table) throws Exception {
        }
    }
}

