/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.hadoop.hbase.util.MultiThreadedWriterBase;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;

public class MultiThreadedReader
extends MultiThreadedAction {
    private static final Log LOG = LogFactory.getLog(MultiThreadedReader.class);
    protected Set<HBaseReaderThread> readers = new HashSet<HBaseReaderThread>();
    private final double verifyPercent;
    protected volatile boolean aborted;
    protected MultiThreadedWriterBase writer = null;
    private final AtomicLong numUniqueKeysVerified = new AtomicLong();
    public static final int DEFAULT_MAX_ERRORS = 10;
    public static final int DEFAULT_KEY_WINDOW = 0;
    public static final int DEFAULT_BATCH_SIZE = 1;
    protected AtomicLong numKeysVerified = new AtomicLong(0L);
    protected AtomicLong numReadErrors = new AtomicLong(0L);
    protected AtomicLong numReadFailures = new AtomicLong(0L);
    protected AtomicLong nullResult = new AtomicLong(0L);
    private int maxErrors = 10;
    private int keyWindow = 0;
    private int batchSize = 1;
    private int regionReplicaId = -1;

    public MultiThreadedReader(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double verifyPercent) throws IOException {
        super(dataGen, conf, tableName, "R");
        this.verifyPercent = verifyPercent;
    }

    public void linkToWriter(MultiThreadedWriterBase writer) {
        this.writer = writer;
        writer.setTrackWroteKeys(true);
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setKeyWindow(int keyWindow) {
        this.keyWindow = keyWindow;
    }

    public void setMultiGetBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRegionReplicaId(int regionReplicaId) {
        this.regionReplicaId = regionReplicaId;
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
        if (this.verbose) {
            LOG.debug((Object)("Reading keys [" + startKey + ", " + endKey + ")"));
        }
        this.addReaderThreads(numThreads);
        this.startThreads(this.readers);
    }

    protected void addReaderThreads(int numThreads) throws IOException {
        for (int i = 0; i < numThreads; ++i) {
            HBaseReaderThread reader = this.createReaderThread(i);
            this.readers.add(reader);
        }
    }

    protected HBaseReaderThread createReaderThread(int readerId) throws IOException {
        HBaseReaderThread reader = new HBaseReaderThread(readerId);
        Threads.setLoggingUncaughtExceptionHandler((Thread)reader);
        return reader;
    }

    public long getNumReadFailures() {
        return this.numReadFailures.get();
    }

    public long getNumReadErrors() {
        return this.numReadErrors.get();
    }

    public long getNumKeysVerified() {
        return this.numKeysVerified.get();
    }

    public long getNumUniqueKeysVerified() {
        return this.numUniqueKeysVerified.get();
    }

    public long getNullResultsCount() {
        return this.nullResult.get();
    }

    @Override
    protected String progressInfo() {
        StringBuilder sb = new StringBuilder();
        MultiThreadedReader.appendToStatus(sb, "verified", this.numKeysVerified.get());
        MultiThreadedReader.appendToStatus(sb, "READ FAILURES", this.numReadFailures.get());
        MultiThreadedReader.appendToStatus(sb, "READ ERRORS", this.numReadErrors.get());
        MultiThreadedReader.appendToStatus(sb, "NULL RESULT", this.nullResult.get());
        return sb.toString();
    }

    public class HBaseReaderThread
    extends Thread {
        protected final int readerId;
        protected final Table table;
        private long curKey;
        protected long startTimeMs;
        private boolean readingRandomKey;
        private boolean printExceptionTrace = true;

        public HBaseReaderThread(int readerId) throws IOException {
            this.readerId = readerId;
            this.table = this.createTable();
            this.setName(this.getClass().getSimpleName() + "_" + readerId);
        }

        protected HTableInterface createTable() throws IOException {
            return MultiThreadedReader.this.connection.getTable(MultiThreadedReader.this.tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runReader();
            }
            finally {
                this.closeTable();
                MultiThreadedReader.this.numThreadsWorking.decrementAndGet();
            }
        }

        protected void closeTable() {
            try {
                if (this.table != null) {
                    this.table.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing table", (Throwable)e);
            }
        }

        private void runReader() {
            if (MultiThreadedReader.this.verbose) {
                LOG.info((Object)("Started thread #" + this.readerId + " for reads..."));
            }
            this.startTimeMs = System.currentTimeMillis();
            this.curKey = MultiThreadedReader.this.startKey;
            long[] keysForThisReader = new long[MultiThreadedReader.this.batchSize];
            while (this.curKey < MultiThreadedReader.this.endKey && !MultiThreadedReader.this.aborted) {
                int readingRandomKeyStartIndex = -1;
                int numKeys = 0;
                do {
                    long k;
                    if ((k = this.getNextKeyToRead()) < MultiThreadedReader.this.startKey || k >= MultiThreadedReader.this.endKey) {
                        MultiThreadedReader.this.numReadErrors.incrementAndGet();
                        throw new AssertionError((Object)("Load tester logic error: proposed key to read " + k + " is out of range (startKey=" + MultiThreadedReader.this.startKey + ", endKey=" + MultiThreadedReader.this.endKey + ")"));
                    }
                    if (k % (long)MultiThreadedReader.this.numThreads != (long)this.readerId || MultiThreadedReader.this.writer != null && MultiThreadedReader.this.writer.failedToWriteKey(k)) continue;
                    keysForThisReader[numKeys] = k;
                    if (this.readingRandomKey && readingRandomKeyStartIndex == -1) {
                        readingRandomKeyStartIndex = numKeys;
                    }
                    ++numKeys;
                } while (numKeys < MultiThreadedReader.this.batchSize && this.curKey < MultiThreadedReader.this.endKey && !MultiThreadedReader.this.aborted);
                if (numKeys <= 0) continue;
                this.readKey(keysForThisReader);
                MultiThreadedReader.this.numUniqueKeysVerified.getAndAdd(readingRandomKeyStartIndex == -1 ? (long)numKeys : (long)readingRandomKeyStartIndex);
            }
        }

        private long maxKeyWeCanRead() {
            long insertedUpToKey = MultiThreadedReader.this.writer.wroteUpToKey();
            if (insertedUpToKey >= MultiThreadedReader.this.endKey - 1L) {
                return MultiThreadedReader.this.endKey - 1L;
            }
            return Math.min(MultiThreadedReader.this.endKey - 1L, MultiThreadedReader.this.writer.wroteUpToKey() - (long)MultiThreadedReader.this.keyWindow);
        }

        protected long getNextKeyToRead() {
            long maxKeyToRead;
            this.readingRandomKey = false;
            if (MultiThreadedReader.this.writer == null || this.curKey <= this.maxKeyWeCanRead()) {
                return this.curKey++;
            }
            while ((maxKeyToRead = this.maxKeyWeCanRead()) < MultiThreadedReader.this.startKey) {
                Threads.sleepWithoutInterrupt((long)50L);
            }
            if (this.curKey <= maxKeyToRead) {
                return this.curKey++;
            }
            this.readingRandomKey = true;
            return MultiThreadedReader.this.startKey + Math.abs(RandomUtils.nextLong()) % (maxKeyToRead - MultiThreadedReader.this.startKey + 1L);
        }

        private Get[] readKey(long[] keysToRead) {
            Get[] gets;
            block8: {
                gets = new Get[keysToRead.length];
                int i = 0;
                for (long keyToRead : keysToRead) {
                    try {
                        gets[i] = this.createGet(keyToRead);
                        if (keysToRead.length == 1) {
                            this.queryKey(gets[i], (double)RandomUtils.nextInt((int)100) < MultiThreadedReader.this.verifyPercent, keyToRead);
                        }
                        ++i;
                    }
                    catch (IOException e) {
                        MultiThreadedReader.this.numReadFailures.addAndGet(1L);
                        LOG.debug((Object)("[" + this.readerId + "] FAILED read, key = " + keyToRead + "" + ", time from start: " + (System.currentTimeMillis() - this.startTimeMs) + " ms"));
                        if (!this.printExceptionTrace) continue;
                        LOG.warn((Object)e);
                        this.printExceptionTrace = false;
                    }
                }
                if (keysToRead.length > 1) {
                    try {
                        this.queryKey(gets, (double)RandomUtils.nextInt((int)100) < MultiThreadedReader.this.verifyPercent, keysToRead);
                    }
                    catch (IOException e) {
                        MultiThreadedReader.this.numReadFailures.addAndGet(gets.length);
                        for (long keyToRead : keysToRead) {
                            LOG.debug((Object)("[" + this.readerId + "] FAILED read, key = " + keyToRead + "" + ", time from start: " + (System.currentTimeMillis() - this.startTimeMs) + " ms"));
                        }
                        if (!this.printExceptionTrace) break block8;
                        LOG.warn((Object)e);
                        this.printExceptionTrace = false;
                    }
                }
            }
            return gets;
        }

        protected Get createGet(long keyToRead) throws IOException {
            byte[][] columnFamilies;
            Get get = new Get(MultiThreadedReader.this.dataGenerator.getDeterministicUniqueKey(keyToRead));
            String cfsString = "";
            for (byte[] cf : columnFamilies = MultiThreadedReader.this.dataGenerator.getColumnFamilies()) {
                get.addFamily(cf);
                if (!MultiThreadedReader.this.verbose) continue;
                if (cfsString.length() > 0) {
                    cfsString = cfsString + ", ";
                }
                cfsString = cfsString + "[" + Bytes.toStringBinary((byte[])cf) + "]";
            }
            get = MultiThreadedReader.this.dataGenerator.beforeGet(keyToRead, get);
            if (MultiThreadedReader.this.regionReplicaId > 0) {
                get.setReplicaId(MultiThreadedReader.this.regionReplicaId);
                get.setConsistency(Consistency.TIMELINE);
            }
            if (MultiThreadedReader.this.verbose) {
                LOG.info((Object)("[" + this.readerId + "] " + "Querying key " + keyToRead + ", cfs " + cfsString));
            }
            return get;
        }

        public void queryKey(Get[] gets, boolean verify, long[] keysToRead) throws IOException {
            long start = System.nanoTime();
            Result[] results = this.table.get(Arrays.asList(gets));
            long end = System.nanoTime();
            this.verifyResultsAndUpdateMetrics(verify, gets, end - start, results, this.table, false);
        }

        public void queryKey(Get get, boolean verify, long keyToRead) throws IOException {
            long start = System.nanoTime();
            Result result = this.table.get(get);
            long end = System.nanoTime();
            this.verifyResultsAndUpdateMetrics(verify, get, end - start, result, this.table, false);
        }

        protected void verifyResultsAndUpdateMetrics(boolean verify, Get[] gets, long elapsedNano, Result[] results, Table table, boolean isNullExpected) throws IOException {
            MultiThreadedReader.this.totalOpTimeMs.addAndGet(elapsedNano / 1000000L);
            MultiThreadedReader.this.numKeys.addAndGet(gets.length);
            int i = 0;
            for (Result result : results) {
                this.verifyResultsAndUpdateMetricsOnAPerGetBasis(verify, gets[i++], result, table, isNullExpected);
            }
        }

        protected void verifyResultsAndUpdateMetrics(boolean verify, Get get, long elapsedNano, Result result, Table table, boolean isNullExpected) throws IOException {
            this.verifyResultsAndUpdateMetrics(verify, new Get[]{get}, elapsedNano, new Result[]{result}, table, isNullExpected);
        }

        private void verifyResultsAndUpdateMetricsOnAPerGetBasis(boolean verify, Get get, Result result, Table table, boolean isNullExpected) throws IOException {
            if (!result.isEmpty()) {
                if (verify) {
                    MultiThreadedReader.this.numKeysVerified.incrementAndGet();
                }
            } else {
                HRegionLocation hloc = MultiThreadedReader.this.connection.getRegionLocation(MultiThreadedReader.this.tableName, get.getRow(), false);
                String rowKey = Bytes.toString((byte[])get.getRow());
                LOG.info((Object)("Key = " + rowKey + ", Region location: " + hloc));
                if (isNullExpected) {
                    MultiThreadedReader.this.nullResult.incrementAndGet();
                    LOG.debug((Object)("Null result obtained for the key =" + rowKey));
                    return;
                }
            }
            boolean isOk = MultiThreadedReader.this.verifyResultAgainstDataGenerator(result, verify, false);
            long numErrorsAfterThis = 0L;
            if (isOk) {
                long cols = 0L;
                for (byte[] cf : result.getMap().keySet()) {
                    cols += (long)result.getFamilyMap(cf).size();
                }
                MultiThreadedReader.this.numCols.addAndGet(cols);
            } else {
                if (MultiThreadedReader.this.writer != null) {
                    LOG.error((Object)("At the time of failure, writer wrote " + MultiThreadedReader.this.writer.numKeys.get() + " keys"));
                }
                numErrorsAfterThis = MultiThreadedReader.this.numReadErrors.incrementAndGet();
            }
            if (numErrorsAfterThis > (long)MultiThreadedReader.this.maxErrors) {
                LOG.error((Object)("Aborting readers -- found more than " + MultiThreadedReader.this.maxErrors + " errors"));
                MultiThreadedReader.this.aborted = true;
            }
        }
    }
}

