/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.ScannerIterator;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.hadoop.io.Text;

public class ScannerImpl
extends ScannerOptions
implements Scanner {
    private Instance instance;
    private TCredentials credentials;
    private Authorizations authorizations;
    private Text table;
    private int size;
    private Range range;
    private boolean isolated = false;

    public ScannerImpl(Instance instance, TCredentials credentials, String table, Authorizations authorizations) {
        ArgumentChecker.notNull(instance, credentials, table, authorizations);
        this.instance = instance;
        this.credentials = credentials;
        this.table = new Text(table);
        this.range = new Range((Key)null, (Key)null);
        this.authorizations = authorizations;
        this.size = 1000;
    }

    @Override
    public synchronized void setRange(Range range) {
        ArgumentChecker.notNull(range);
        this.range = range;
    }

    @Override
    public synchronized Range getRange() {
        return this.range;
    }

    @Override
    public synchronized void setBatchSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        this.size = size;
    }

    @Override
    public synchronized int getBatchSize() {
        return this.size;
    }

    @Override
    public synchronized Iterator<Map.Entry<Key, Value>> iterator() {
        return new ScannerIterator(this.instance, this.credentials, this.table, this.authorizations, this.range, this.size, this.getTimeOut(), this, this.isolated);
    }

    @Override
    public synchronized void enableIsolation() {
        this.isolated = true;
    }

    @Override
    public synchronized void disableIsolation() {
        this.isolated = false;
    }

    @Override
    @Deprecated
    public void setTimeOut(int timeOut) {
        if (timeOut == Integer.MAX_VALUE) {
            this.setTimeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            this.setTimeout(timeOut, TimeUnit.SECONDS);
        }
    }

    @Override
    @Deprecated
    public int getTimeOut() {
        long timeout = this.getTimeout(TimeUnit.SECONDS);
        if (timeout >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeout;
    }
}

