/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;

public class SourceSwitchingIterator
implements SortedKeyValueIterator<Key, Value>,
InterruptibleIterator {
    private DataSource source;
    private SortedKeyValueIterator<Key, Value> iter;
    private Key key;
    private Value val;
    private Range range;
    private boolean inclusive;
    private Collection<ByteSequence> columnFamilies;
    private boolean onlySwitchAfterRow;
    private AtomicBoolean iflag;
    private final List<SourceSwitchingIterator> copies;

    private SourceSwitchingIterator(DataSource source, boolean onlySwitchAfterRow, List<SourceSwitchingIterator> copies, AtomicBoolean iflag) {
        this.source = source;
        this.onlySwitchAfterRow = onlySwitchAfterRow;
        this.copies = copies;
        this.iflag = iflag;
        copies.add(this);
    }

    public SourceSwitchingIterator(DataSource source, boolean onlySwitchAfterRow) {
        this(source, onlySwitchAfterRow, Collections.synchronizedList(new ArrayList()), null);
    }

    public SourceSwitchingIterator(DataSource source) {
        this(source, false);
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new SourceSwitchingIterator(this.source.getDeepCopyDataSource(env), this.onlySwitchAfterRow, this.copies, this.iflag);
    }

    @Override
    public Key getTopKey() {
        return this.key;
    }

    @Override
    public Value getTopValue() {
        return this.val;
    }

    @Override
    public boolean hasTop() {
        return this.key != null;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void next() throws IOException {
        this.readNext(false);
    }

    private synchronized void readNext(boolean initialSeek) throws IOException {
        boolean seekNeeded;
        boolean bl = seekNeeded = !this.onlySwitchAfterRow && this.switchSource() || initialSeek;
        if (seekNeeded) {
            if (initialSeek) {
                this.iter.seek(this.range, this.columnFamilies, this.inclusive);
            } else {
                this.iter.seek(new Range(this.key, false, this.range.getEndKey(), this.range.isEndKeyInclusive()), this.columnFamilies, this.inclusive);
            }
        } else {
            this.iter.next();
            if (this.onlySwitchAfterRow && this.iter.hasTop() && !this.source.isCurrent() && !this.key.getRowData().equals(this.iter.getTopKey().getRowData())) {
                this.switchSource();
                this.iter.seek(new Range(this.key.followingKey(PartialKey.ROW), true, this.range.getEndKey(), this.range.isEndKeyInclusive()), this.columnFamilies, this.inclusive);
            }
        }
        if (this.iter.hasTop()) {
            Key nextKey = this.iter.getTopKey();
            Value nextVal = this.iter.getTopValue();
            try {
                this.key = (Key)nextKey.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IOException(e);
            }
            this.val = nextVal;
        } else {
            this.key = null;
            this.val = null;
        }
    }

    private boolean switchSource() throws IOException {
        if (!this.source.isCurrent()) {
            this.source = this.source.getNewDataSource();
            this.iter = this.source.iterator();
            if (this.iflag != null) {
                ((InterruptibleIterator)this.iter).setInterruptFlag(this.iflag);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.range = range;
        this.inclusive = inclusive;
        this.columnFamilies = columnFamilies;
        if (this.iter == null) {
            this.iter = this.source.iterator();
            if (this.iflag != null) {
                ((InterruptibleIterator)this.iter).setInterruptFlag(this.iflag);
            }
        }
        this.readNext(true);
    }

    private synchronized void _switchNow() throws IOException {
        if (this.onlySwitchAfterRow) {
            throw new IllegalStateException("Can only switch on row boundries");
        }
        if (this.switchSource() && this.key != null) {
            this.iter.seek(new Range(this.key, true, this.range.getEndKey(), this.range.isEndKeyInclusive()), this.columnFamilies, this.inclusive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchNow() throws IOException {
        List<SourceSwitchingIterator> list = this.copies;
        synchronized (list) {
            for (SourceSwitchingIterator ssi : this.copies) {
                ssi._switchNow();
            }
        }
    }

    @Override
    public synchronized void setInterruptFlag(AtomicBoolean flag) {
        if (this.copies.size() != 1) {
            throw new IllegalStateException("setInterruptFlag() called after deep copies made " + this.copies.size());
        }
        this.iflag = flag;
        if (this.iter != null) {
            ((InterruptibleIterator)this.iter).setInterruptFlag(flag);
        }
    }

    public static interface DataSource {
        public boolean isCurrent();

        public DataSource getNewDataSource();

        public DataSource getDeepCopyDataSource(IteratorEnvironment var1);

        public SortedKeyValueIterator<Key, Value> iterator() throws IOException;
    }
}

