/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductCombination;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManagerReal;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductFilter;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;

class CartesianProductEdgeManagerPartitioned
extends CartesianProductEdgeManagerReal {
    private int positionId;
    private CartesianProductFilter filter;
    private int[] taskIdMapping;
    private int[] numPartitions;
    private List<String> sources;

    public CartesianProductEdgeManagerPartitioned(EdgeManagerPluginContext context) {
        super(context);
    }

    @Override
    public void initialize(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        this.numPartitions = Ints.toArray(config.getNumPartitionsList());
        this.sources = config.getSourcesList();
        this.positionId = this.sources.indexOf(this.getContext().getSourceVertexName());
        if (config.hasFilterClassName()) {
            UserPayload userPayload = config.hasFilterUserPayload() ? UserPayload.create((ByteBuffer)ByteBuffer.wrap(config.getFilterUserPayload().toByteArray())) : null;
            this.filter = (CartesianProductFilter)ReflectionUtils.createClazzInstance((String)config.getFilterClassName(), (Class[])new Class[]{UserPayload.class}, (Object[])new UserPayload[]{userPayload});
        }
        this.generateTaskIdMapping();
    }

    @Override
    public int routeInputErrorEventToSource(int destTaskId, int failedInputId) throws Exception {
        return failedInputId;
    }

    @Override
    public EdgeManagerPluginOnDemand.EventRouteMetadata routeDataMovementEventToDestination(int srcTaskId, int srcOutputId, int destTaskId) throws Exception {
        int partition = CartesianProductCombination.fromTaskId(this.numPartitions, this.getIdealTaskId(destTaskId)).getCombination().get(this.positionId);
        return srcOutputId != partition ? null : EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)1, (int[])new int[]{srcTaskId});
    }

    @Override
    @Nullable
    public EdgeManagerPluginOnDemand.CompositeEventRouteMetadata routeCompositeDataMovementEventToDestination(int srcTaskId, int destTaskId) throws Exception {
        int partition = CartesianProductCombination.fromTaskId(this.numPartitions, this.getIdealTaskId(destTaskId)).getCombination().get(this.positionId);
        return EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)1, (int)srcTaskId, (int)partition);
    }

    @Override
    @Nullable
    public EdgeManagerPluginOnDemand.EventRouteMetadata routeInputSourceTaskFailedEventToDestination(int srcTaskId, int destTaskId) throws Exception {
        return EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)1, (int[])new int[]{srcTaskId});
    }

    @Override
    public int getNumDestinationTaskPhysicalInputs(int destTaskId) {
        return this.getContext().getSourceVertexNumTasks();
    }

    @Override
    public int getNumSourceTaskPhysicalOutputs(int srcTaskId) {
        return this.numPartitions[this.positionId];
    }

    @Override
    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        return this.getContext().getDestinationVertexNumTasks();
    }

    private void generateTaskIdMapping() {
        ArrayList<Integer> idealTaskId = new ArrayList<Integer>();
        HashMap<String, Integer> vertexPartitionMap = new HashMap<String, Integer>();
        CartesianProductCombination combination = new CartesianProductCombination(this.numPartitions);
        combination.firstTask();
        do {
            for (int i = 0; i < this.sources.size(); ++i) {
                vertexPartitionMap.put(this.sources.get(i), combination.getCombination().get(i));
            }
            if (this.filter != null && !this.filter.isValidCombination(vertexPartitionMap)) continue;
            idealTaskId.add(combination.getTaskId());
        } while (combination.nextTask());
        this.taskIdMapping = Ints.toArray(idealTaskId);
    }

    private int getIdealTaskId(int realTaskId) {
        return this.taskIdMapping[realTaskId];
    }
}

