/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

public final class Address
extends Number
implements Comparable<Address> {
    private static final Address NULL = new Address(0L);
    private final long address;

    private Address(long address2) {
        this.address = address2;
    }

    public Address(Address address2) {
        this.address = address2.address;
    }

    public final long address() {
        return this.address;
    }

    @Override
    public final int intValue() {
        return (int)this.address;
    }

    @Override
    public final long longValue() {
        return this.address;
    }

    @Override
    public final float floatValue() {
        return this.address;
    }

    @Override
    public final double doubleValue() {
        return this.address;
    }

    public final long nativeAddress() {
        return this.address;
    }

    public final int hashCode() {
        return (int)(this.address ^ this.address >>> 32);
    }

    public final boolean equals(Object obj) {
        return obj instanceof Address && this.address == ((Address)obj).address || obj == null && this.address == 0L;
    }

    public final String toString() {
        return Long.toString(this.address, 10);
    }

    public final String toHexString() {
        return Long.toString(this.address, 16);
    }

    @Override
    public final int compareTo(Address other) {
        return this.address < other.address ? -1 : (this.address > other.address ? 1 : 0);
    }

    public final boolean isNull() {
        return this.address == 0L;
    }

    public static Address valueOf(long address2) {
        return address2 == 0L ? NULL : new Address(address2);
    }

    public static Address valueOf(int address2) {
        return address2 == 0 ? NULL : new Address((long)address2 & 0xFFFFFFFFL);
    }
}

