/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.PopulateMetadataTable;
import org.apache.accumulo.server.tabletserver.UniqueNameAllocator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class MapImportFileNames
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    MapImportFileNames(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Path path = new Path(this.tableInfo.importDir, "mappings.txt");
        BufferedWriter mappingsWriter = null;
        try {
            FileSystem fs = environment.getFileSystem();
            fs.mkdirs(new Path(this.tableInfo.importDir));
            FileStatus[] files = fs.listStatus(new Path(this.tableInfo.exportDir));
            UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
            mappingsWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path)));
            for (FileStatus fileStatus : files) {
                String fileName = fileStatus.getPath().getName();
                String[] sa = fileName.split("\\.");
                String extension = "";
                if (sa.length > 1) {
                    extension = sa[sa.length - 1];
                    if (!FileOperations.getValidExtensions().contains(extension)) {
                        continue;
                    }
                } else {
                    extension = "map";
                }
                String newName = "I" + namer.getNextName() + "." + extension;
                mappingsWriter.append(fileName);
                mappingsWriter.append(':');
                mappingsWriter.append(newName);
                mappingsWriter.newLine();
            }
            mappingsWriter.close();
            mappingsWriter = null;
            PopulateMetadataTable populateMetadataTable = new PopulateMetadataTable(this.tableInfo);
            return populateMetadataTable;
        }
        catch (IOException ioe) {
            log.warn((Object)ioe.getMessage(), (Throwable)ioe);
            throw new ThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error writing mapping file " + path + " " + ioe.getMessage());
        }
        finally {
            if (mappingsWriter != null) {
                try {
                    mappingsWriter.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)("Failed to close " + path), (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        env.getFileSystem().delete(new Path(this.tableInfo.importDir), true);
    }
}

