/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.io.IOException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class BulkFailedCopyProcessor
implements DistributedWorkQueue.Processor {
    private static final Logger log = Logger.getLogger(BulkFailedCopyProcessor.class);

    @Override
    public DistributedWorkQueue.Processor newProcessor() {
        return new BulkFailedCopyProcessor();
    }

    @Override
    public void process(String workID, byte[] data) {
        String[] paths = new String(data).split(",");
        Path orig = new Path(paths[0]);
        Path dest = new Path(paths[1]);
        Path tmp = new Path(dest.getParent(), dest.getName() + ".tmp");
        try {
            FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
            org.apache.hadoop.fs.FileUtil.copy((FileSystem)fs, (Path)orig, (FileSystem)fs, (Path)tmp, (boolean)false, (boolean)true, (Configuration)CachedConfiguration.getInstance());
            fs.rename(tmp, dest);
            log.debug((Object)("copied " + orig + " to " + dest));
        }
        catch (IOException ex) {
            try {
                FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
                fs.create(dest).close();
                log.warn((Object)(" marked " + dest + " failed"), (Throwable)ex);
            }
            catch (IOException e) {
                log.error((Object)("Unable to create failure flag file " + dest), (Throwable)e);
            }
        }
    }
}

