/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.BatchWriterImpl;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Writer;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.MetadataTable;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class MetadataTable
extends org.apache.accumulo.core.util.MetadataTable {
    private static final Text EMPTY_TEXT = new Text();
    private static Map<TCredentials, Writer> metadata_tables = new HashMap<TCredentials, Writer>();
    private static final Logger log = Logger.getLogger(MetadataTable.class);
    private static final int SAVE_ROOT_TABLET_RETRIES = 3;

    private MetadataTable() {
    }

    public static synchronized Writer getMetadataTable(TCredentials credentials) {
        Writer metadataTable = metadata_tables.get(credentials);
        if (metadataTable == null) {
            metadataTable = new Writer(HdfsZooInstance.getInstance(), credentials, "!0");
            metadata_tables.put(credentials, metadataTable);
        }
        return metadataTable;
    }

    public static void putLockID(ZooLock zooLock, Mutation m) {
        Constants.METADATA_LOCK_COLUMN.put(m, new Value(zooLock.getLockID().serialize(ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/").getBytes()));
    }

    public static void update(TCredentials credentials, Mutation m) {
        MetadataTable.update(credentials, null, m);
    }

    public static void update(TCredentials credentials, ZooLock zooLock, Mutation m) {
        Writer t = MetadataTable.getMetadataTable(credentials);
        if (zooLock != null) {
            MetadataTable.putLockID(zooLock, m);
        }
        while (true) {
            try {
                t.update(m);
                return;
            }
            catch (AccumuloException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (AccumuloSecurityException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (ConstraintViolationException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (TableNotFoundException e) {
                log.error((Object)e, (Throwable)e);
            }
            UtilWaitThread.sleep((long)1000L);
        }
    }

    public static void updateTabletDataFile(KeyExtent extent, String path, String mergeFile, MetadataTable.DataFileValue dfv, String time, TCredentials credentials, Set<String> filesInUseByScans, String address, ZooLock zooLock, Set<String> unusedWalLogs, TServerInstance lastLocation, long flushId) {
        if (extent.equals((Object)Constants.ROOT_TABLET_EXTENT)) {
            if (unusedWalLogs != null) {
                ZooReaderWriter zk = ZooReaderWriter.getInstance();
                String root = MetadataTable.getZookeeperLogLocation();
                boolean foundEntry = false;
                block3: for (String entry : unusedWalLogs) {
                    String[] parts = entry.split("/");
                    String zpath = root + "/" + parts[1];
                    while (true) {
                        try {
                            if (!zk.exists(zpath)) continue block3;
                            zk.recursiveDelete(zpath, ZooUtil.NodeMissingPolicy.SKIP);
                            foundEntry = true;
                            continue block3;
                        }
                        catch (KeeperException e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        UtilWaitThread.sleep((long)1000L);
                    }
                }
                if (unusedWalLogs.size() > 0 && !foundEntry) {
                    log.warn((Object)("WALog entry for root tablet did not exist " + unusedWalLogs));
                }
            }
            return;
        }
        Mutation m = new Mutation(extent.getMetadataEntry());
        if (dfv.getNumEntries() > 0L) {
            m.put(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(path), new Value(dfv.encode()));
            Constants.METADATA_TIME_COLUMN.put(m, new Value(time.getBytes()));
            TServerInstance self = MetadataTable.getTServerInstance(address, zooLock);
            self.putLastLocation(m);
            if (lastLocation != null && !lastLocation.equals(self)) {
                lastLocation.clearLastLocation(m);
            }
        }
        if (unusedWalLogs != null) {
            for (String entry : unusedWalLogs) {
                m.putDelete(Constants.METADATA_LOG_COLUMN_FAMILY, new Text(entry));
            }
        }
        for (String scanFile : filesInUseByScans) {
            m.put(Constants.METADATA_SCANFILE_COLUMN_FAMILY, new Text(scanFile), new Value("".getBytes()));
        }
        if (mergeFile != null) {
            m.putDelete(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(mergeFile));
        }
        Constants.METADATA_FLUSH_COLUMN.put(m, new Value((flushId + "").getBytes()));
        MetadataTable.update(credentials, zooLock, m);
    }

    private static TServerInstance getTServerInstance(String address, ZooLock zooLock) {
        while (true) {
            try {
                return new TServerInstance(address, zooLock.getSessionId());
            }
            catch (KeeperException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
            }
            UtilWaitThread.sleep((long)1000L);
        }
    }

    public static void updateTabletFlushID(KeyExtent extent, long flushID, TCredentials credentials, ZooLock zooLock) {
        if (!extent.isRootTablet()) {
            Mutation m = new Mutation(extent.getMetadataEntry());
            Constants.METADATA_FLUSH_COLUMN.put(m, new Value((flushID + "").getBytes()));
            MetadataTable.update(credentials, zooLock, m);
        }
    }

    public static void updateTabletCompactID(KeyExtent extent, long compactID, TCredentials credentials, ZooLock zooLock) {
        if (!extent.isRootTablet()) {
            Mutation m = new Mutation(extent.getMetadataEntry());
            Constants.METADATA_COMPACT_COLUMN.put(m, new Value((compactID + "").getBytes()));
            MetadataTable.update(credentials, zooLock, m);
        }
    }

    public static void updateTabletDataFile(long tid, KeyExtent extent, Map<String, MetadataTable.DataFileValue> estSizes, String time, TCredentials credentials, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        byte[] tidBytes = Long.toString(tid).getBytes();
        for (Map.Entry<String, MetadataTable.DataFileValue> entry : estSizes.entrySet()) {
            Text file = new Text(entry.getKey());
            m.put(Constants.METADATA_DATAFILE_COLUMN_FAMILY, file, new Value(entry.getValue().encode()));
            m.put(Constants.METADATA_BULKFILE_COLUMN_FAMILY, file, new Value(tidBytes));
        }
        Constants.METADATA_TIME_COLUMN.put(m, new Value(time.getBytes()));
        MetadataTable.update(credentials, zooLock, m);
    }

    public static void addTablet(KeyExtent extent, String path, TCredentials credentials, char timeType, ZooLock lock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        Constants.METADATA_DIRECTORY_COLUMN.put(m, new Value(path.getBytes()));
        Constants.METADATA_TIME_COLUMN.put(m, new Value((timeType + "0").getBytes()));
        MetadataTable.update(credentials, lock, m);
    }

    public static void updateTabletPrevEndRow(KeyExtent extent, TCredentials credentials) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataTable.update(credentials, m);
    }

    public static SortedMap<KeyExtent, Text> getMetadataDirectoryEntries(SortedMap<Key, Value> entries) {
        Text datafile = null;
        Value prevRow = null;
        TreeMap<KeyExtent, Text> results = new TreeMap<KeyExtent, Text>();
        Text lastRowFromKey = new Text();
        Text colf = new Text();
        Text colq = new Text();
        for (Map.Entry<Key, Value> entry : entries.entrySet()) {
            Key key = entry.getKey();
            Value val = entry.getValue();
            if (key.compareRow(lastRowFromKey) != 0) {
                prevRow = null;
                datafile = null;
                key.getRow(lastRowFromKey);
            }
            if (Constants.METADATA_DIRECTORY_COLUMN.equals(colf = key.getColumnFamily(colf), colq = key.getColumnQualifier(colq))) {
                datafile = new Text(val.toString());
            } else if (Constants.METADATA_PREV_ROW_COLUMN.equals(colf, colq)) {
                prevRow = new Value(val);
            }
            if (datafile == null || prevRow == null) continue;
            KeyExtent ke = new KeyExtent(key.getRow(), prevRow);
            results.put(ke, datafile);
            datafile = null;
            prevRow = null;
        }
        return results;
    }

    public static boolean recordRootTabletLocation(String address) {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        for (int i = 0; i < 3; ++i) {
            try {
                log.info((Object)("trying to write root tablet location to ZooKeeper as " + address));
                String zRootLocPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/root_tablet/location";
                zoo.putPersistentData(zRootLocPath, address.getBytes(), ZooUtil.NodeExistsPolicy.OVERWRITE);
                return true;
            }
            catch (Exception e) {
                log.error((Object)("Master: unable to save root tablet location in zookeeper. exception: " + e), (Throwable)e);
                continue;
            }
        }
        log.error((Object)"Giving up after 3 retries");
        return false;
    }

    public static SortedMap<String, MetadataTable.DataFileValue> getDataFileSizes(KeyExtent extent, TCredentials credentials) {
        Map.Entry entry;
        TreeMap<String, MetadataTable.DataFileValue> sizes = new TreeMap<String, MetadataTable.DataFileValue>();
        ScannerImpl mdScanner = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Constants.NO_AUTHS);
        mdScanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        Text row = extent.getMetadataEntry();
        Key endKey = new Key(row, Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(""));
        endKey = endKey.followingKey(PartialKey.ROW_COLFAM);
        mdScanner.setRange(new Range(new Key(row), endKey));
        Iterator i$ = mdScanner.iterator();
        while (i$.hasNext() && ((Key)(entry = (Map.Entry)i$.next()).getKey()).getRow().equals((Object)row)) {
            MetadataTable.DataFileValue dfv = new MetadataTable.DataFileValue(((Value)entry.getValue()).get());
            sizes.put(((Key)entry.getKey()).getColumnQualifier().toString(), dfv);
        }
        return sizes;
    }

    public static void addNewTablet(KeyExtent extent, String path, TServerInstance location, Map<String, MetadataTable.DataFileValue> datafileSizes, Map<String, Long> bulkLoadedFiles, TCredentials credentials, String time, long lastFlushID, long lastCompactID, ZooLock zooLock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        Constants.METADATA_DIRECTORY_COLUMN.put(m, new Value(path.getBytes()));
        Constants.METADATA_TIME_COLUMN.put(m, new Value(time.getBytes()));
        if (lastFlushID > 0L) {
            Constants.METADATA_FLUSH_COLUMN.put(m, new Value(("" + lastFlushID).getBytes()));
        }
        if (lastCompactID > 0L) {
            Constants.METADATA_COMPACT_COLUMN.put(m, new Value(("" + lastCompactID).getBytes()));
        }
        if (location != null) {
            m.put(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY, location.asColumnQualifier(), location.asMutationValue());
            m.putDelete(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY, location.asColumnQualifier());
        }
        for (Map.Entry<String, MetadataTable.DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(entry.getKey()), new Value(entry.getValue().encode()));
        }
        for (Map.Entry<String, Object> entry : bulkLoadedFiles.entrySet()) {
            byte[] tidBytes = Long.toString((Long)entry.getValue()).getBytes();
            m.put(Constants.METADATA_BULKFILE_COLUMN_FAMILY, new Text(entry.getKey()), new Value(tidBytes));
        }
        MetadataTable.update(credentials, zooLock, m);
    }

    public static void rollBackSplit(Text metadataEntry, Text oldPrevEndRow, TCredentials credentials, ZooLock zooLock) {
        KeyExtent ke = new KeyExtent(metadataEntry, oldPrevEndRow);
        Mutation m = ke.getPrevRowUpdateMutation();
        Constants.METADATA_SPLIT_RATIO_COLUMN.putDelete(m);
        Constants.METADATA_OLD_PREV_ROW_COLUMN.putDelete(m);
        MetadataTable.update(credentials, zooLock, m);
    }

    public static void splitTablet(KeyExtent extent, Text oldPrevEndRow, double splitRatio, TCredentials credentials, ZooLock zooLock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        Constants.METADATA_SPLIT_RATIO_COLUMN.put(m, new Value(Double.toString(splitRatio).getBytes()));
        Constants.METADATA_OLD_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow((Text)oldPrevEndRow));
        Constants.METADATA_CHOPPED_COLUMN.putDelete(m);
        MetadataTable.update(credentials, zooLock, m);
    }

    public static void finishSplit(Text metadataEntry, Map<String, MetadataTable.DataFileValue> datafileSizes, List<String> highDatafilesToRemove, TCredentials credentials, ZooLock zooLock) {
        Mutation m = new Mutation(metadataEntry);
        Constants.METADATA_SPLIT_RATIO_COLUMN.putDelete(m);
        Constants.METADATA_OLD_PREV_ROW_COLUMN.putDelete(m);
        Constants.METADATA_CHOPPED_COLUMN.putDelete(m);
        for (Map.Entry<String, MetadataTable.DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(entry.getKey()), new Value(entry.getValue().encode()));
        }
        for (String pathToRemove : highDatafilesToRemove) {
            m.putDelete(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(pathToRemove));
        }
        MetadataTable.update(credentials, zooLock, m);
    }

    public static void finishSplit(KeyExtent extent, Map<String, MetadataTable.DataFileValue> datafileSizes, List<String> highDatafilesToRemove, TCredentials credentials, ZooLock zooLock) {
        MetadataTable.finishSplit(extent.getMetadataEntry(), datafileSizes, highDatafilesToRemove, credentials, zooLock);
    }

    public static void replaceDatafiles(KeyExtent extent, Set<String> datafilesToDelete, Set<String> scanFiles, String path, Long compactionId, MetadataTable.DataFileValue size, TCredentials credentials, String address, TServerInstance lastLocation, ZooLock zooLock) {
        MetadataTable.replaceDatafiles(extent, datafilesToDelete, scanFiles, path, compactionId, size, credentials, address, lastLocation, zooLock, true);
    }

    public static void replaceDatafiles(KeyExtent extent, Set<String> datafilesToDelete, Set<String> scanFiles, String path, Long compactionId, MetadataTable.DataFileValue size, TCredentials credentials, String address, TServerInstance lastLocation, ZooLock zooLock, boolean insertDeleteFlags) {
        if (insertDeleteFlags) {
            MetadataTable.addDeleteEntries(extent, datafilesToDelete, credentials);
        }
        Mutation m = new Mutation(extent.getMetadataEntry());
        for (String pathToRemove : datafilesToDelete) {
            m.putDelete(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(pathToRemove));
        }
        for (String scanFile : scanFiles) {
            m.put(Constants.METADATA_SCANFILE_COLUMN_FAMILY, new Text(scanFile), new Value("".getBytes()));
        }
        if (size.getNumEntries() > 0L) {
            m.put(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(path), new Value(size.encode()));
        }
        if (compactionId != null) {
            Constants.METADATA_COMPACT_COLUMN.put(m, new Value(("" + compactionId).getBytes()));
        }
        TServerInstance self = MetadataTable.getTServerInstance(address, zooLock);
        self.putLastLocation(m);
        if (lastLocation != null && !lastLocation.equals(self)) {
            lastLocation.clearLastLocation(m);
        }
        MetadataTable.update(credentials, zooLock, m);
    }

    public static void addDeleteEntries(KeyExtent extent, Set<String> datafilesToDelete, TCredentials credentials) {
        String tableId = extent.getTableId().toString();
        for (String pathToRemove : datafilesToDelete) {
            MetadataTable.update(credentials, MetadataTable.createDeleteMutation(tableId, pathToRemove));
        }
    }

    public static void addDeleteEntry(String tableId, String path) {
        MetadataTable.update(SecurityConstants.getSystemCredentials(), MetadataTable.createDeleteMutation(tableId, path));
    }

    public static Mutation createDeleteMutation(String tableId, String pathToRemove) {
        String prefix = "~del";
        if (tableId.equals("!0")) {
            prefix = "!!~del";
        }
        Mutation delFlag = pathToRemove.startsWith("../") ? new Mutation(new Text(prefix + pathToRemove.substring(2))) : new Mutation(new Text(prefix + "/" + tableId + pathToRemove));
        delFlag.put(EMPTY_TEXT, EMPTY_TEXT, new Value(new byte[0]));
        return delFlag;
    }

    public static void removeScanFiles(KeyExtent extent, Set<String> scanFiles, TCredentials credentials, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        for (String pathToRemove : scanFiles) {
            m.putDelete(Constants.METADATA_SCANFILE_COLUMN_FAMILY, new Text(pathToRemove));
        }
        MetadataTable.update(credentials, zooLock, m);
    }

    private static KeyExtent fixSplit(Text table, Text metadataEntry, Text metadataPrevEndRow, Value oper, double splitRatio, TServerInstance tserver, TCredentials credentials, String time, long initFlushID, long initCompactID, ZooLock lock) throws AccumuloException {
        if (metadataPrevEndRow == null) {
            throw new AccumuloException("Split tablet does not have prev end row, something is amiss, extent = " + metadataEntry);
        }
        Key prevRowKey = new Key(new Text(KeyExtent.getMetadataEntry((Text)table, (Text)metadataPrevEndRow)));
        ScannerImpl scanner2 = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Constants.NO_AUTHS);
        scanner2.setRange(new Range(prevRowKey, prevRowKey.followingKey(PartialKey.ROW)));
        if (!scanner2.iterator().hasNext()) {
            log.info((Object)("Rolling back incomplete split " + metadataEntry + " " + metadataPrevEndRow));
            MetadataTable.rollBackSplit(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper), credentials, lock);
            return new KeyExtent(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper));
        }
        log.info((Object)("Finishing incomplete split " + metadataEntry + " " + metadataPrevEndRow));
        ArrayList<String> highDatafilesToRemove = new ArrayList<String>();
        ScannerImpl scanner3 = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Constants.NO_AUTHS);
        Key rowKey = new Key(metadataEntry);
        TreeMap<String, MetadataTable.DataFileValue> origDatafileSizes = new TreeMap<String, MetadataTable.DataFileValue>();
        TreeMap<String, MetadataTable.DataFileValue> highDatafileSizes = new TreeMap<String, MetadataTable.DataFileValue>();
        TreeMap<String, MetadataTable.DataFileValue> lowDatafileSizes = new TreeMap<String, MetadataTable.DataFileValue>();
        scanner3.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        scanner3.setRange(new Range(rowKey, rowKey.followingKey(PartialKey.ROW)));
        for (Map.Entry entry : scanner3) {
            if (((Key)entry.getKey()).compareColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY) != 0) continue;
            origDatafileSizes.put(((Key)entry.getKey()).getColumnQualifier().toString(), new MetadataTable.DataFileValue(((Value)entry.getValue()).get()));
        }
        MetadataTable.splitDatafiles(table, metadataPrevEndRow, splitRatio, new HashMap<String, FileUtil.FileInfo>(), origDatafileSizes, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
        MetadataTable.finishSplit(metadataEntry, highDatafileSizes, highDatafilesToRemove, credentials, lock);
        return new KeyExtent(metadataEntry, KeyExtent.encodePrevEndRow((Text)metadataPrevEndRow));
    }

    public static void splitDatafiles(Text table, Text midRow, double splitRatio, Map<String, FileUtil.FileInfo> firstAndLastRows, SortedMap<String, MetadataTable.DataFileValue> datafiles, SortedMap<String, MetadataTable.DataFileValue> lowDatafileSizes, SortedMap<String, MetadataTable.DataFileValue> highDatafileSizes, List<String> highDatafilesToRemove) {
        for (Map.Entry<String, MetadataTable.DataFileValue> entry : datafiles.entrySet()) {
            long lowEntries;
            long lowSize;
            Text firstRow = null;
            Text lastRow = null;
            boolean rowsKnown = false;
            FileUtil.FileInfo mfi = firstAndLastRows.get(entry.getKey());
            if (mfi != null) {
                firstRow = mfi.getFirstRow();
                lastRow = mfi.getLastRow();
                rowsKnown = true;
            }
            if (rowsKnown && firstRow.compareTo((BinaryComparable)midRow) > 0) {
                long highSize = entry.getValue().getSize();
                long highEntries = entry.getValue().getNumEntries();
                highDatafileSizes.put(entry.getKey(), new MetadataTable.DataFileValue(highSize, highEntries, entry.getValue().getTime()));
                continue;
            }
            if (rowsKnown && lastRow.compareTo((BinaryComparable)midRow) <= 0) {
                lowSize = entry.getValue().getSize();
                lowEntries = entry.getValue().getNumEntries();
                lowDatafileSizes.put(entry.getKey(), new MetadataTable.DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
                highDatafilesToRemove.add(entry.getKey());
                continue;
            }
            lowSize = (long)Math.floor((double)entry.getValue().getSize() * splitRatio);
            lowEntries = (long)Math.floor((double)entry.getValue().getNumEntries() * splitRatio);
            lowDatafileSizes.put(entry.getKey(), new MetadataTable.DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
            long highSize = (long)Math.ceil((double)entry.getValue().getSize() * (1.0 - splitRatio));
            long highEntries = (long)Math.ceil((double)entry.getValue().getNumEntries() * (1.0 - splitRatio));
            highDatafileSizes.put(entry.getKey(), new MetadataTable.DataFileValue(highSize, highEntries, entry.getValue().getTime()));
        }
    }

    public static KeyExtent fixSplit(Text metadataEntry, SortedMap<ColumnFQ, Value> columns, TServerInstance tserver, TCredentials credentials, ZooLock lock) throws AccumuloException {
        log.info((Object)("Incomplete split " + metadataEntry + " attempting to fix"));
        Value oper = (Value)columns.get(Constants.METADATA_OLD_PREV_ROW_COLUMN);
        if (columns.get(Constants.METADATA_SPLIT_RATIO_COLUMN) == null) {
            throw new IllegalArgumentException("Metadata entry does not have split ratio (" + metadataEntry + ")");
        }
        double splitRatio = Double.parseDouble(new String(((Value)columns.get(Constants.METADATA_SPLIT_RATIO_COLUMN)).get()));
        Value prevEndRowIBW = (Value)columns.get(Constants.METADATA_PREV_ROW_COLUMN);
        if (prevEndRowIBW == null) {
            throw new IllegalArgumentException("Metadata entry does not have prev row (" + metadataEntry + ")");
        }
        Value time = (Value)columns.get(Constants.METADATA_TIME_COLUMN);
        if (time == null) {
            throw new IllegalArgumentException("Metadata entry does not have time (" + metadataEntry + ")");
        }
        Value flushID = (Value)columns.get(Constants.METADATA_FLUSH_COLUMN);
        long initFlushID = -1L;
        if (flushID != null) {
            initFlushID = Long.parseLong(flushID.toString());
        }
        Value compactID = (Value)columns.get(Constants.METADATA_COMPACT_COLUMN);
        long initCompactID = -1L;
        if (compactID != null) {
            initCompactID = Long.parseLong(compactID.toString());
        }
        Text metadataPrevEndRow = KeyExtent.decodePrevEndRow((Value)prevEndRowIBW);
        Text table = new KeyExtent(metadataEntry, (Text)null).getTableId();
        return MetadataTable.fixSplit(table, metadataEntry, metadataPrevEndRow, oper, splitRatio, tserver, credentials, time.toString(), initFlushID, initCompactID, lock);
    }

    public static void deleteTable(String tableId, boolean insertDeletes, TCredentials credentials, ZooLock lock) throws AccumuloException {
        Key key;
        ScannerImpl ms = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Constants.NO_AUTHS);
        Text tableIdText = new Text(tableId);
        BatchWriterImpl bw = new BatchWriterImpl(HdfsZooInstance.getInstance(), credentials, "!0", new BatchWriterConfig().setMaxMemory(1000000L).setMaxLatency(120000L, TimeUnit.MILLISECONDS).setMaxWriteThreads(2));
        Mutation m = null;
        ms.setRange(new KeyExtent(tableIdText, null, null).toMetadataRange());
        if (insertDeletes) {
            ms.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
            Constants.METADATA_DIRECTORY_COLUMN.fetch((ScannerBase)ms);
            for (Map.Entry cell : ms) {
                String relPath;
                key = (Key)cell.getKey();
                if (key.getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY) && !(relPath = key.getColumnQualifier().toString()).startsWith("../")) {
                    bw.addMutation(MetadataTable.createDeleteMutation(tableId, relPath));
                }
                if (!Constants.METADATA_DIRECTORY_COLUMN.hasColumns(key)) continue;
                bw.addMutation(MetadataTable.createDeleteMutation(tableId, ((Value)cell.getValue()).toString()));
            }
            bw.flush();
            ms.clearColumns();
        }
        for (Map.Entry cell : ms) {
            key = (Key)cell.getKey();
            if (m == null) {
                m = new Mutation(key.getRow());
                if (lock != null) {
                    MetadataTable.putLockID(lock, m);
                }
            }
            if (key.getRow().compareTo(m.getRow(), 0, m.getRow().length) != 0) {
                bw.addMutation(m);
                m = new Mutation(key.getRow());
                if (lock != null) {
                    MetadataTable.putLockID(lock, m);
                }
            }
            m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
        }
        if (m != null) {
            bw.addMutation(m);
        }
        bw.close();
    }

    private static String getZookeeperLogLocation() {
        return ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/root_tablet/walogs";
    }

    public static void addLogEntry(TCredentials credentials, LogEntry entry, ZooLock zooLock) {
        block7: {
            if (entry.extent.isRootTablet()) {
                String root = MetadataTable.getZookeeperLogLocation();
                while (true) {
                    try {
                        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                        if (zoo.isLockHeld(zooLock.getLockID())) {
                            zoo.putPersistentData(root + "/" + entry.filename, entry.toBytes(), ZooUtil.NodeExistsPolicy.OVERWRITE);
                        }
                        break block7;
                    }
                    catch (KeeperException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    UtilWaitThread.sleep((long)1000L);
                }
            }
            String value = StringUtil.join(entry.logSet, (String)";") + "|" + entry.tabletId;
            Mutation m = new Mutation(entry.extent.getMetadataEntry());
            m.put(Constants.METADATA_LOG_COLUMN_FAMILY, new Text(entry.server + "/" + entry.filename), new Value(value.getBytes()));
            MetadataTable.update(credentials, zooLock, m);
        }
    }

    public static LogEntry entryFromKeyValue(Key key, Value value) {
        LogEntry e = new LogEntry();
        e.extent = new KeyExtent(key.getRow(), EMPTY_TEXT);
        String[] parts = key.getColumnQualifier().toString().split("/");
        e.server = parts[0];
        e.filename = parts[1];
        parts = value.toString().split("\\|");
        e.tabletId = Integer.parseInt(parts[1]);
        e.logSet = Arrays.asList(parts[0].split(";"));
        e.timestamp = key.getTimestamp();
        return e;
    }

    public static Pair<List<LogEntry>, SortedMap<String, MetadataTable.DataFileValue>> getFileAndLogEntries(TCredentials credentials, KeyExtent extent) throws KeeperException, InterruptedException, IOException {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        TreeMap<String, MetadataTable.DataFileValue> sizes = new TreeMap<String, MetadataTable.DataFileValue>();
        if (extent.isRootTablet()) {
            FileStatus[] files;
            MetadataTable.getRootLogEntries(result);
            FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
            for (FileStatus fileStatus : files = fs.listStatus(new Path(ServerConstants.getRootTabletDir()))) {
                if (fileStatus.getPath().toString().endsWith("_tmp")) continue;
                MetadataTable.DataFileValue dfv = new MetadataTable.DataFileValue(0L, 0L);
                sizes.put("/root_tablet/" + fileStatus.getPath().getName(), dfv);
            }
        } else {
            ScannerImpl scanner = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Constants.NO_AUTHS);
            scanner.fetchColumnFamily(Constants.METADATA_LOG_COLUMN_FAMILY);
            scanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
            scanner.setRange(extent.toMetadataRange());
            for (Map.Entry entry : scanner) {
                if (!((Key)entry.getKey()).getRow().equals((Object)extent.getMetadataEntry())) {
                    throw new RuntimeException("Unexpected row " + ((Key)entry.getKey()).getRow() + " expected " + extent.getMetadataEntry());
                }
                if (((Key)entry.getKey()).getColumnFamily().equals((Object)Constants.METADATA_LOG_COLUMN_FAMILY)) {
                    result.add(MetadataTable.entryFromKeyValue((Key)entry.getKey(), (Value)entry.getValue()));
                    continue;
                }
                if (((Key)entry.getKey()).getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY)) {
                    MetadataTable.DataFileValue dfv = new MetadataTable.DataFileValue(((Value)entry.getValue()).get());
                    sizes.put(((Key)entry.getKey()).getColumnQualifier().toString(), dfv);
                    continue;
                }
                throw new RuntimeException("Unexpected col fam " + ((Key)entry.getKey()).getColumnFamily());
            }
        }
        return new Pair(result, sizes);
    }

    public static List<LogEntry> getLogEntries(TCredentials credentials, KeyExtent extent) throws IOException, KeeperException, InterruptedException {
        log.info((Object)("Scanning logging entries for " + extent));
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        if (extent.equals((Object)Constants.ROOT_TABLET_EXTENT)) {
            log.info((Object)"Getting logs for root tablet from zookeeper");
            MetadataTable.getRootLogEntries(result);
        } else {
            log.info((Object)("Scanning metadata for logs used for tablet " + extent));
            Scanner scanner = MetadataTable.getTabletLogScanner(credentials, extent);
            Text pattern = extent.getMetadataEntry();
            for (Map.Entry entry : scanner) {
                Text row = ((Key)entry.getKey()).getRow();
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)Constants.METADATA_LOG_COLUMN_FAMILY) || !row.equals((Object)pattern)) continue;
                result.add(MetadataTable.entryFromKeyValue((Key)entry.getKey(), (Value)entry.getValue()));
            }
        }
        Collections.sort(result, new Comparator<LogEntry>(){

            @Override
            public int compare(LogEntry o1, LogEntry o2) {
                long diff = o1.timestamp - o2.timestamp;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        log.info((Object)("Returning logs " + result + " for extent " + extent));
        return result;
    }

    private static void getRootLogEntries(ArrayList<LogEntry> result) throws KeeperException, InterruptedException, IOException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        String root = MetadataTable.getZookeeperLogLocation();
        result.clear();
        for (String child : zoo.getChildren(root)) {
            LogEntry e = new LogEntry();
            try {
                e.fromBytes(zoo.getData(root + "/" + child, null));
                result.add(e);
            }
            catch (KeeperException.NoNodeException ex) {}
        }
    }

    private static Scanner getTabletLogScanner(TCredentials credentials, KeyExtent extent) {
        ScannerImpl scanner = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Constants.NO_AUTHS);
        scanner.fetchColumnFamily(Constants.METADATA_LOG_COLUMN_FAMILY);
        Text start = extent.getMetadataEntry();
        Key endKey = new Key(start, Constants.METADATA_LOG_COLUMN_FAMILY);
        endKey = endKey.followingKey(PartialKey.ROW_COLFAM);
        scanner.setRange(new Range(new Key(start), endKey));
        return scanner;
    }

    public static Iterator<LogEntry> getLogEntries(TCredentials creds) throws IOException, KeeperException, InterruptedException {
        return new LogEntryIterator(creds);
    }

    public static void removeUnusedWALEntries(KeyExtent extent, List<LogEntry> logEntries, ZooLock zooLock) {
        block2: for (LogEntry entry : logEntries) {
            if (entry.extent.isRootTablet()) {
                String root = MetadataTable.getZookeeperLogLocation();
                while (true) {
                    try {
                        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                        if (!zoo.isLockHeld(zooLock.getLockID())) continue block2;
                        zoo.recursiveDelete(root + "/" + entry.filename, ZooUtil.NodeMissingPolicy.SKIP);
                        continue block2;
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        UtilWaitThread.sleep((long)1000L);
                        continue;
                    }
                    break;
                }
            }
            Mutation m = new Mutation(entry.extent.getMetadataEntry());
            m.putDelete(Constants.METADATA_LOG_COLUMN_FAMILY, new Text(entry.server + "/" + entry.filename));
            MetadataTable.update(SecurityConstants.getSystemCredentials(), zooLock, m);
        }
    }

    private static void getFiles(Set<String> files, Map<Key, Value> tablet, String srcTableId) {
        for (Map.Entry<Key, Value> entry : tablet.entrySet()) {
            if (!entry.getKey().getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY)) continue;
            String cf = entry.getKey().getColumnQualifier().toString();
            if (srcTableId != null && !cf.startsWith("../")) {
                cf = "../" + srcTableId + entry.getKey().getColumnQualifier();
            }
            files.add(cf);
        }
    }

    private static Mutation createCloneMutation(String srcTableId, String tableId, Map<Key, Value> tablet) {
        KeyExtent ke = new KeyExtent(tablet.keySet().iterator().next().getRow(), (Text)null);
        Mutation m = new Mutation(KeyExtent.getMetadataEntry((Text)new Text(tableId), (Text)ke.getEndRow()));
        for (Map.Entry<Key, Value> entry : tablet.entrySet()) {
            if (entry.getKey().getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY)) {
                String cf = entry.getKey().getColumnQualifier().toString();
                if (!cf.startsWith("../")) {
                    cf = "../" + srcTableId + entry.getKey().getColumnQualifier();
                }
                m.put(entry.getKey().getColumnFamily(), new Text(cf), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY)) {
                m.put(Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY, entry.getKey().getColumnQualifier(), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY)) continue;
            m.put(entry.getKey().getColumnFamily(), entry.getKey().getColumnQualifier(), entry.getValue());
        }
        return m;
    }

    private static Scanner createCloneScanner(String tableId, Connector conn) throws TableNotFoundException {
        IsolatedScanner mscanner = new IsolatedScanner(conn.createScanner("!METADATA", Constants.NO_AUTHS));
        mscanner.setRange(new KeyExtent(new Text(tableId), null, null).toMetadataRange());
        mscanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        mscanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        mscanner.fetchColumnFamily(Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY);
        mscanner.fetchColumnFamily(Constants.METADATA_CLONED_COLUMN_FAMILY);
        Constants.METADATA_PREV_ROW_COLUMN.fetch((ScannerBase)mscanner);
        Constants.METADATA_TIME_COLUMN.fetch((ScannerBase)mscanner);
        return mscanner;
    }

    static void initializeClone(String srcTableId, String tableId, Connector conn, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        TabletIterator ti = new TabletIterator(MetadataTable.createCloneScanner(srcTableId, conn), new KeyExtent(new Text(srcTableId), null, null).toMetadataRange(), true, true);
        if (!ti.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId);
        }
        while (ti.hasNext()) {
            bw.addMutation(MetadataTable.createCloneMutation(srcTableId, tableId, (Map<Key, Value>)ti.next()));
        }
        bw.flush();
    }

    static int compareEndRows(Text endRow1, Text endRow2) {
        return new KeyExtent(new Text("0"), endRow1, null).compareTo(new KeyExtent(new Text("0"), endRow2, null));
    }

    static int checkClone(String srcTableId, String tableId, Connector conn, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        TabletIterator srcIter = new TabletIterator(MetadataTable.createCloneScanner(srcTableId, conn), new KeyExtent(new Text(srcTableId), null, null).toMetadataRange(), true, true);
        TabletIterator cloneIter = new TabletIterator(MetadataTable.createCloneScanner(tableId, conn), new KeyExtent(new Text(tableId), null, null).toMetadataRange(), true, true);
        if (!cloneIter.hasNext() || !srcIter.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId + " tableId=" + tableId);
        }
        int rewrites = 0;
        while (cloneIter.hasNext()) {
            Mutation m;
            Object cloneTablet = cloneIter.next();
            Text cloneEndRow = new KeyExtent(((Key)cloneTablet.keySet().iterator().next()).getRow(), (Text)null).getEndRow();
            HashSet<String> cloneFiles = new HashSet<String>();
            boolean cloneSuccessful = false;
            for (Map.Entry entry : cloneTablet.entrySet()) {
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)Constants.METADATA_CLONED_COLUMN_FAMILY)) continue;
                cloneSuccessful = true;
                break;
            }
            if (!cloneSuccessful) {
                MetadataTable.getFiles(cloneFiles, (Map<Key, Value>)cloneTablet, null);
            }
            ArrayList<Object> srcTablets = new ArrayList<Object>();
            Object srcTablet = srcIter.next();
            srcTablets.add(srcTablet);
            Text srcEndRow = new KeyExtent(((Key)srcTablet.keySet().iterator().next()).getRow(), (Text)null).getEndRow();
            int cmp = MetadataTable.compareEndRows(cloneEndRow, srcEndRow);
            if (cmp < 0) {
                throw new TabletIterator.TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
            }
            HashSet<String> srcFiles = new HashSet<String>();
            if (!cloneSuccessful) {
                MetadataTable.getFiles(srcFiles, (Map<Key, Value>)srcTablet, srcTableId);
            }
            while (cmp > 0) {
                srcTablet = srcIter.next();
                srcTablets.add(srcTablet);
                srcEndRow = new KeyExtent(((Key)srcTablet.keySet().iterator().next()).getRow(), (Text)null).getEndRow();
                cmp = MetadataTable.compareEndRows(cloneEndRow, srcEndRow);
                if (cmp < 0) {
                    throw new TabletIterator.TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
                }
                if (cloneSuccessful) continue;
                MetadataTable.getFiles(srcFiles, (Map<Key, Value>)srcTablet, srcTableId);
            }
            if (cloneSuccessful) continue;
            if (!srcFiles.containsAll(cloneFiles)) {
                m = new Mutation(((Key)cloneTablet.keySet().iterator().next()).getRow());
                for (Map.Entry entry : cloneTablet.entrySet()) {
                    Key k = (Key)entry.getKey();
                    m.putDelete(k.getColumnFamily(), k.getColumnQualifier(), k.getTimestamp());
                }
                bw.addMutation(m);
                for (Map map : srcTablets) {
                    bw.addMutation(MetadataTable.createCloneMutation(srcTableId, tableId, map));
                }
                ++rewrites;
                continue;
            }
            m = new Mutation(((Key)cloneTablet.keySet().iterator().next()).getRow());
            m.put(Constants.METADATA_CLONED_COLUMN_FAMILY, new Text(""), new Value("OK".getBytes()));
            bw.addMutation(m);
        }
        bw.flush();
        return rewrites;
    }

    public static void cloneTable(Instance instance, String srcTableId, String tableId) throws Exception {
        Connector conn = instance.getConnector("!SYSTEM", SecurityConstants.getSystemToken());
        BatchWriter bw = conn.createBatchWriter("!METADATA", new BatchWriterConfig());
        while (true) {
            try {
                int rewrites;
                MetadataTable.initializeClone(srcTableId, tableId, conn, bw);
                while ((rewrites = MetadataTable.checkClone(srcTableId, tableId, conn, bw)) != 0) {
                }
                bw.flush();
            }
            catch (TabletIterator.TabletDeletedException tde) {
                bw.flush();
                MetadataTable.deleteTable(tableId, false, SecurityConstants.getSystemCredentials(), null);
                log.debug((Object)("Tablets merged in table " + srcTableId + " while attempting to clone, trying again"));
                UtilWaitThread.sleep((long)100L);
                continue;
            }
            break;
        }
        Scanner mscanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
        mscanner.setRange(new KeyExtent(new Text(tableId), null, null).toMetadataRange());
        mscanner.fetchColumnFamily(Constants.METADATA_CLONED_COLUMN_FAMILY);
        int dirCount = 0;
        for (Map.Entry entry : mscanner) {
            Key k = (Key)entry.getKey();
            Mutation m = new Mutation(k.getRow());
            m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
            Constants.METADATA_DIRECTORY_COLUMN.put(m, new Value(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])"/c-".getBytes())));
            bw.addMutation(m);
        }
        bw.close();
    }

    public static void chopped(KeyExtent extent, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        Constants.METADATA_CHOPPED_COLUMN.put(m, new Value("chopped".getBytes()));
        MetadataTable.update(SecurityConstants.getSystemCredentials(), zooLock, m);
    }

    public static void removeBulkLoadEntries(Connector conn, String tableId, long tid) throws Exception {
        IsolatedScanner mscanner = new IsolatedScanner(conn.createScanner("!METADATA", Constants.NO_AUTHS));
        mscanner.setRange(new KeyExtent(new Text(tableId), null, null).toMetadataRange());
        mscanner.fetchColumnFamily(Constants.METADATA_BULKFILE_COLUMN_FAMILY);
        BatchWriter bw = conn.createBatchWriter("!METADATA", new BatchWriterConfig());
        for (Map.Entry entry : mscanner) {
            log.debug((Object)("Looking at entry " + entry + " with tid " + tid));
            if (Long.parseLong(((Value)entry.getValue()).toString()) != tid) continue;
            log.debug((Object)("deleting entry " + entry));
            Mutation m = new Mutation(((Key)entry.getKey()).getRow());
            m.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
            bw.addMutation(m);
        }
        bw.close();
    }

    public static List<String> getBulkFilesLoaded(Connector conn, KeyExtent extent, long tid) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            IsolatedScanner mscanner = new IsolatedScanner(conn.createScanner("!METADATA", Constants.NO_AUTHS));
            mscanner.setRange(extent.toMetadataRange());
            mscanner.fetchColumnFamily(Constants.METADATA_BULKFILE_COLUMN_FAMILY);
            for (Map.Entry entry : mscanner) {
                if (Long.parseLong(((Value)entry.getValue()).toString()) != tid) continue;
                result.add(((Key)entry.getKey()).getColumnQualifier().toString());
            }
            return result;
        }
        catch (TableNotFoundException ex) {
            throw new RuntimeException("Onos! teh metadata table has vanished!!");
        }
    }

    public static Map<String, Long> getBulkFilesLoaded(TCredentials credentials, KeyExtent extent) {
        return MetadataTable.getBulkFilesLoaded(credentials, extent.getMetadataEntry());
    }

    public static Map<String, Long> getBulkFilesLoaded(TCredentials credentials, Text metadataRow) {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        ScannerImpl scanner = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Constants.NO_AUTHS);
        scanner.setRange(new Range(metadataRow));
        scanner.fetchColumnFamily(Constants.METADATA_BULKFILE_COLUMN_FAMILY);
        for (Map.Entry entry : scanner) {
            String file = ((Key)entry.getKey()).getColumnQualifier().toString();
            Long tid = Long.parseLong(((Value)entry.getValue()).toString());
            ret.put(file, tid);
        }
        return ret;
    }

    public static void addBulkLoadInProgressFlag(String path) {
        Mutation m = new Mutation((CharSequence)("~blip" + path));
        m.put(EMPTY_TEXT, EMPTY_TEXT, new Value(new byte[0]));
        MetadataTable.update(SecurityConstants.getSystemCredentials(), m);
    }

    public static void removeBulkLoadInProgressFlag(String path) {
        Mutation m = new Mutation((CharSequence)("~blip" + path));
        m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
        MetadataTable.update(SecurityConstants.getSystemCredentials(), m);
    }

    public static void moveMetaDeleteMarkers(Instance instance, TCredentials creds) {
        Map.Entry entry;
        String row;
        ScannerImpl scanner = new ScannerImpl(instance, creds, "!0", Constants.NO_AUTHS);
        scanner.setRange(new Range(Constants.METADATA_DELETES_KEYSPACE));
        Iterator i$ = scanner.iterator();
        while (i$.hasNext() && (row = ((Key)(entry = (Map.Entry)i$.next()).getKey()).getRow().toString()).startsWith("~del/!0")) {
            String filename = row.substring("~del".length());
            log.info((Object)("Moving " + filename + " marker to the root tablet"));
            Mutation m = new Mutation((CharSequence)("!!~del" + filename));
            m.put(new byte[0], new byte[0], new byte[0]);
            MetadataTable.update(creds, m);
            m = new Mutation(((Key)entry.getKey()).getRow());
            m.putDelete(new byte[0], new byte[0]);
            MetadataTable.update(creds, m);
        }
    }

    static class LogEntryIterator
    implements Iterator<LogEntry> {
        Iterator<LogEntry> rootTabletEntries = null;
        Iterator<Map.Entry<Key, Value>> metadataEntries = null;

        LogEntryIterator(TCredentials creds) throws IOException, KeeperException, InterruptedException {
            this.rootTabletEntries = MetadataTable.getLogEntries(creds, Constants.ROOT_TABLET_EXTENT).iterator();
            try {
                Scanner scanner = HdfsZooInstance.getInstance().getConnector(creds.getPrincipal(), CredentialHelper.extractToken((TCredentials)creds)).createScanner("!METADATA", Constants.NO_AUTHS);
                scanner.fetchColumnFamily(Constants.METADATA_LOG_COLUMN_FAMILY);
                this.metadataEntries = scanner.iterator();
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.rootTabletEntries.hasNext() || this.metadataEntries.hasNext();
        }

        @Override
        public LogEntry next() {
            if (this.rootTabletEntries.hasNext()) {
                return this.rootTabletEntries.next();
            }
            Map.Entry<Key, Value> entry = this.metadataEntries.next();
            return MetadataTable.entryFromKeyValue(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class LogEntry {
        public KeyExtent extent;
        public long timestamp;
        public String server;
        public String filename;
        public int tabletId;
        public Collection<String> logSet;

        public String toString() {
            return this.extent.toString() + " " + this.filename + " (" + this.tabletId + ")";
        }

        public String getName() {
            return this.server + "/" + this.filename;
        }

        public byte[] toBytes() throws IOException {
            DataOutputBuffer out = new DataOutputBuffer();
            this.extent.write((DataOutput)out);
            out.writeLong(this.timestamp);
            out.writeUTF(this.server);
            out.writeUTF(this.filename);
            out.write(this.tabletId);
            out.write(this.logSet.size());
            for (String s : this.logSet) {
                out.writeUTF(s);
            }
            return Arrays.copyOf(out.getData(), out.getLength());
        }

        public void fromBytes(byte[] bytes) throws IOException {
            DataInputBuffer inp = new DataInputBuffer();
            inp.reset(bytes, bytes.length);
            this.extent = new KeyExtent();
            this.extent.readFields((DataInput)inp);
            this.timestamp = inp.readLong();
            this.server = inp.readUTF();
            this.filename = inp.readUTF();
            this.tabletId = inp.read();
            int count = inp.read();
            ArrayList<String> logSet = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                logSet.add(inp.readUTF());
            }
            this.logSet = logSet;
        }
    }
}

