/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.accumulo.trace.thrift.TInfo;

public class TraceWrap {
    public static <T> T service(final T instance) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                if (args == null || args.length < 1 || args[0] == null || !(args[0] instanceof TInfo)) {
                    try {
                        return method.invoke(instance, args);
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getCause();
                    }
                }
                Span span2 = Trace.trace((TInfo)args[0], method.getName());
                try {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
                finally {
                    span2.stop();
                }
            }
        };
        return (T)Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
    }

    public static <T> T client(final T instance) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                if (args == null || args.length < 1 || args[0] != null) {
                    return method.invoke(instance, args);
                }
                Class<?> klass = method.getParameterTypes()[0];
                if (TInfo.class.isAssignableFrom(klass)) {
                    args[0] = Tracer.traceInfo();
                }
                Span span2 = Trace.start("client:" + method.getName());
                try {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
                finally {
                    span2.stop();
                }
            }
        };
        return (T)Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
    }
}

