/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempAppPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class CapacitySchedulerPreemptionUtils {
    public static Map<String, Resource> getResToObtainByPartitionForLeafQueue(CapacitySchedulerPreemptionContext context, String queueName, Resource clusterResource) {
        HashMap<String, Resource> resToObtainByPartition = new HashMap<String, Resource>();
        for (TempQueuePerPartition qT : context.getQueuePartitions(queueName)) {
            if (qT.preemptionDisabled || !Resources.greaterThan((ResourceCalculator)context.getResourceCalculator(), (Resource)clusterResource, (Resource)qT.getActuallyToBePreempted(), (Resource)Resources.none())) continue;
            resToObtainByPartition.put(qT.partition, Resources.clone((Resource)qT.getActuallyToBePreempted()));
        }
        return resToObtainByPartition;
    }

    public static boolean isContainerAlreadySelected(RMContainer container, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates) {
        if (null == selectedCandidates) {
            return false;
        }
        Set<RMContainer> containers = selectedCandidates.get(container.getApplicationAttemptId());
        if (containers == null) {
            return false;
        }
        return containers.contains(container);
    }

    public static void deductPreemptableResourcesBasedSelectedCandidates(CapacitySchedulerPreemptionContext context, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates) {
        for (Set<RMContainer> containers : selectedCandidates.values()) {
            for (RMContainer c : containers) {
                Object schedulerNode = context.getScheduler().getSchedulerNode(c.getAllocatedNode());
                if (null == schedulerNode) continue;
                String partition = ((SchedulerNode)schedulerNode).getPartition();
                String queue = c.getQueueName();
                TempQueuePerPartition tq = context.getQueueByPartition(queue, partition);
                Resource res = c.getReservedResource();
                if (null == res) {
                    res = c.getAllocatedResource();
                }
                if (null == res) continue;
                tq.deductActuallyToBePreempted(context.getResourceCalculator(), tq.totalPartitionResource, res);
                Collection<TempAppPerPartition> tas = tq.getApps();
                if (null == tas || tas.isEmpty()) continue;
                CapacitySchedulerPreemptionUtils.deductPreemptableResourcePerApp(context, tq.totalPartitionResource, tas, res);
            }
        }
    }

    private static void deductPreemptableResourcePerApp(CapacitySchedulerPreemptionContext context, Resource totalPartitionResource, Collection<TempAppPerPartition> tas, Resource res) {
        for (TempAppPerPartition ta : tas) {
            ta.deductActuallyToBePreempted(context.getResourceCalculator(), totalPartitionResource, res);
        }
    }

    public static boolean tryPreemptContainerAndDeductResToObtain(ResourceCalculator rc, CapacitySchedulerPreemptionContext context, Map<String, Resource> resourceToObtainByPartitions, RMContainer rmContainer, Resource clusterResource, Map<ApplicationAttemptId, Set<RMContainer>> preemptMap, Resource totalPreemptionAllowed, boolean conservativeDRF) {
        ApplicationAttemptId attemptId = rmContainer.getApplicationAttemptId();
        if (CapacitySchedulerPreemptionUtils.preemptMapContains(preemptMap, attemptId, rmContainer)) {
            return false;
        }
        String nodePartition = CapacitySchedulerPreemptionUtils.getPartitionByNodeId(context, rmContainer.getAllocatedNode());
        Resource toObtainByPartition = resourceToObtainByPartitions.get(nodePartition);
        if (null == toObtainByPartition) {
            return false;
        }
        for (ResourceInformation ri : toObtainByPartition.getResources()) {
            if (ri.getValue() != 0L) continue;
            ri.setValue(-1L);
        }
        if (rc.isAnyMajorResourceAboveZero(toObtainByPartition) && Resources.fitsIn((ResourceCalculator)rc, (Resource)clusterResource, (Resource)rmContainer.getAllocatedResource(), (Resource)totalPreemptionAllowed)) {
            Resource toObtainAfterPreemption = Resources.subtract((Resource)toObtainByPartition, (Resource)rmContainer.getAllocatedResource());
            boolean doPreempt = conservativeDRF ? !rc.isAnyMajorResourceZeroOrNegative(toObtainByPartition) : Resources.lessThan((ResourceCalculator)rc, (Resource)clusterResource, (Resource)Resources.componentwiseMax((Resource)toObtainAfterPreemption, (Resource)Resources.none()), (Resource)Resources.componentwiseMax((Resource)toObtainByPartition, (Resource)Resources.none()));
            if (!doPreempt) {
                return false;
            }
            Resources.subtractFrom((Resource)toObtainByPartition, (Resource)rmContainer.getAllocatedResource());
            Resources.subtractFrom((Resource)totalPreemptionAllowed, (Resource)rmContainer.getAllocatedResource());
            if (Resources.lessThanOrEqual((ResourceCalculator)rc, (Resource)clusterResource, (Resource)toObtainByPartition, (Resource)Resources.none())) {
                resourceToObtainByPartitions.remove(nodePartition);
            }
            CapacitySchedulerPreemptionUtils.addToPreemptMap(preemptMap, attemptId, rmContainer);
            return true;
        }
        return false;
    }

    private static String getPartitionByNodeId(CapacitySchedulerPreemptionContext context, NodeId nodeId) {
        return ((FiCaSchedulerNode)context.getScheduler().getSchedulerNode(nodeId)).getPartition();
    }

    private static void addToPreemptMap(Map<ApplicationAttemptId, Set<RMContainer>> preemptMap, ApplicationAttemptId appAttemptId, RMContainer containerToPreempt) {
        Set<RMContainer> set = preemptMap.get(appAttemptId);
        if (null == set) {
            set = new HashSet<RMContainer>();
            preemptMap.put(appAttemptId, set);
        }
        set.add(containerToPreempt);
    }

    private static boolean preemptMapContains(Map<ApplicationAttemptId, Set<RMContainer>> preemptMap, ApplicationAttemptId attemptId, RMContainer rmContainer) {
        Set<RMContainer> rmContainers = preemptMap.get(attemptId);
        if (null == rmContainers) {
            return false;
        }
        return rmContainers.contains(rmContainer);
    }
}

