/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetChannelValueCharacterString is the corresponding interface of BACnetChannelValueCharacterString
type BACnetChannelValueCharacterString interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetChannelValue
	// GetCharacterStringValue returns CharacterStringValue (property field)
	GetCharacterStringValue() BACnetApplicationTagCharacterString
	// IsBACnetChannelValueCharacterString is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetChannelValueCharacterString()
	// CreateBuilder creates a BACnetChannelValueCharacterStringBuilder
	CreateBACnetChannelValueCharacterStringBuilder() BACnetChannelValueCharacterStringBuilder
}

// _BACnetChannelValueCharacterString is the data-structure of this message
type _BACnetChannelValueCharacterString struct {
	BACnetChannelValueContract
	CharacterStringValue BACnetApplicationTagCharacterString
}

var _ BACnetChannelValueCharacterString = (*_BACnetChannelValueCharacterString)(nil)
var _ BACnetChannelValueRequirements = (*_BACnetChannelValueCharacterString)(nil)

// NewBACnetChannelValueCharacterString factory function for _BACnetChannelValueCharacterString
func NewBACnetChannelValueCharacterString(peekedTagHeader BACnetTagHeader, characterStringValue BACnetApplicationTagCharacterString) *_BACnetChannelValueCharacterString {
	if characterStringValue == nil {
		panic("characterStringValue of type BACnetApplicationTagCharacterString for BACnetChannelValueCharacterString must not be nil")
	}
	_result := &_BACnetChannelValueCharacterString{
		BACnetChannelValueContract: NewBACnetChannelValue(peekedTagHeader),
		CharacterStringValue:       characterStringValue,
	}
	_result.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetChannelValueCharacterStringBuilder is a builder for BACnetChannelValueCharacterString
type BACnetChannelValueCharacterStringBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(characterStringValue BACnetApplicationTagCharacterString) BACnetChannelValueCharacterStringBuilder
	// WithCharacterStringValue adds CharacterStringValue (property field)
	WithCharacterStringValue(BACnetApplicationTagCharacterString) BACnetChannelValueCharacterStringBuilder
	// WithCharacterStringValueBuilder adds CharacterStringValue (property field) which is build by the builder
	WithCharacterStringValueBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetChannelValueCharacterStringBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetChannelValueBuilder
	// Build builds the BACnetChannelValueCharacterString or returns an error if something is wrong
	Build() (BACnetChannelValueCharacterString, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetChannelValueCharacterString
}

// NewBACnetChannelValueCharacterStringBuilder() creates a BACnetChannelValueCharacterStringBuilder
func NewBACnetChannelValueCharacterStringBuilder() BACnetChannelValueCharacterStringBuilder {
	return &_BACnetChannelValueCharacterStringBuilder{_BACnetChannelValueCharacterString: new(_BACnetChannelValueCharacterString)}
}

type _BACnetChannelValueCharacterStringBuilder struct {
	*_BACnetChannelValueCharacterString

	parentBuilder *_BACnetChannelValueBuilder

	collectedErr []error
}

var _ (BACnetChannelValueCharacterStringBuilder) = (*_BACnetChannelValueCharacterStringBuilder)(nil)

func (b *_BACnetChannelValueCharacterStringBuilder) setParent(contract BACnetChannelValueContract) {
	b.BACnetChannelValueContract = contract
	contract.(*_BACnetChannelValue)._SubType = b._BACnetChannelValueCharacterString
}

func (b *_BACnetChannelValueCharacterStringBuilder) WithMandatoryFields(characterStringValue BACnetApplicationTagCharacterString) BACnetChannelValueCharacterStringBuilder {
	return b.WithCharacterStringValue(characterStringValue)
}

func (b *_BACnetChannelValueCharacterStringBuilder) WithCharacterStringValue(characterStringValue BACnetApplicationTagCharacterString) BACnetChannelValueCharacterStringBuilder {
	b.CharacterStringValue = characterStringValue
	return b
}

func (b *_BACnetChannelValueCharacterStringBuilder) WithCharacterStringValueBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetChannelValueCharacterStringBuilder {
	builder := builderSupplier(b.CharacterStringValue.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.CharacterStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetChannelValueCharacterStringBuilder) Build() (BACnetChannelValueCharacterString, error) {
	if b.CharacterStringValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'characterStringValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetChannelValueCharacterString.deepCopy(), nil
}

func (b *_BACnetChannelValueCharacterStringBuilder) MustBuild() BACnetChannelValueCharacterString {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetChannelValueCharacterStringBuilder) Done() BACnetChannelValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetChannelValueBuilder().(*_BACnetChannelValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetChannelValueCharacterStringBuilder) buildForBACnetChannelValue() (BACnetChannelValue, error) {
	return b.Build()
}

func (b *_BACnetChannelValueCharacterStringBuilder) DeepCopy() any {
	_copy := b.CreateBACnetChannelValueCharacterStringBuilder().(*_BACnetChannelValueCharacterStringBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetChannelValueCharacterStringBuilder creates a BACnetChannelValueCharacterStringBuilder
func (b *_BACnetChannelValueCharacterString) CreateBACnetChannelValueCharacterStringBuilder() BACnetChannelValueCharacterStringBuilder {
	if b == nil {
		return NewBACnetChannelValueCharacterStringBuilder()
	}
	return &_BACnetChannelValueCharacterStringBuilder{_BACnetChannelValueCharacterString: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetChannelValueCharacterString) GetParent() BACnetChannelValueContract {
	return m.BACnetChannelValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetChannelValueCharacterString) GetCharacterStringValue() BACnetApplicationTagCharacterString {
	return m.CharacterStringValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetChannelValueCharacterString(structType any) BACnetChannelValueCharacterString {
	if casted, ok := structType.(BACnetChannelValueCharacterString); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetChannelValueCharacterString); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetChannelValueCharacterString) GetTypeName() string {
	return "BACnetChannelValueCharacterString"
}

func (m *_BACnetChannelValueCharacterString) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetChannelValueContract.(*_BACnetChannelValue).getLengthInBits(ctx))

	// Simple field (characterStringValue)
	lengthInBits += m.CharacterStringValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetChannelValueCharacterString) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetChannelValueCharacterString) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetChannelValue) (__bACnetChannelValueCharacterString BACnetChannelValueCharacterString, err error) {
	m.BACnetChannelValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetChannelValueCharacterString"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetChannelValueCharacterString")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	characterStringValue, err := ReadSimpleField[BACnetApplicationTagCharacterString](ctx, "characterStringValue", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'characterStringValue' field"))
	}
	m.CharacterStringValue = characterStringValue

	if closeErr := readBuffer.CloseContext("BACnetChannelValueCharacterString"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetChannelValueCharacterString")
	}

	return m, nil
}

func (m *_BACnetChannelValueCharacterString) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetChannelValueCharacterString) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetChannelValueCharacterString"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetChannelValueCharacterString")
		}

		if err := WriteSimpleField[BACnetApplicationTagCharacterString](ctx, "characterStringValue", m.GetCharacterStringValue(), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'characterStringValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetChannelValueCharacterString"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetChannelValueCharacterString")
		}
		return nil
	}
	return m.BACnetChannelValueContract.(*_BACnetChannelValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetChannelValueCharacterString) IsBACnetChannelValueCharacterString() {}

func (m *_BACnetChannelValueCharacterString) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetChannelValueCharacterString) deepCopy() *_BACnetChannelValueCharacterString {
	if m == nil {
		return nil
	}
	_BACnetChannelValueCharacterStringCopy := &_BACnetChannelValueCharacterString{
		m.BACnetChannelValueContract.(*_BACnetChannelValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.CharacterStringValue),
	}
	_BACnetChannelValueCharacterStringCopy.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = m
	return _BACnetChannelValueCharacterStringCopy
}

func (m *_BACnetChannelValueCharacterString) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
