/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCountBeforeChange is the corresponding interface of BACnetConstructedDataCountBeforeChange
type BACnetConstructedDataCountBeforeChange interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCountBeforeChange returns CountBeforeChange (property field)
	GetCountBeforeChange() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataCountBeforeChange is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCountBeforeChange()
	// CreateBuilder creates a BACnetConstructedDataCountBeforeChangeBuilder
	CreateBACnetConstructedDataCountBeforeChangeBuilder() BACnetConstructedDataCountBeforeChangeBuilder
}

// _BACnetConstructedDataCountBeforeChange is the data-structure of this message
type _BACnetConstructedDataCountBeforeChange struct {
	BACnetConstructedDataContract
	CountBeforeChange BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataCountBeforeChange = (*_BACnetConstructedDataCountBeforeChange)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCountBeforeChange)(nil)

// NewBACnetConstructedDataCountBeforeChange factory function for _BACnetConstructedDataCountBeforeChange
func NewBACnetConstructedDataCountBeforeChange(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, countBeforeChange BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCountBeforeChange {
	if countBeforeChange == nil {
		panic("countBeforeChange of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataCountBeforeChange must not be nil")
	}
	_result := &_BACnetConstructedDataCountBeforeChange{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		CountBeforeChange:             countBeforeChange,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCountBeforeChangeBuilder is a builder for BACnetConstructedDataCountBeforeChange
type BACnetConstructedDataCountBeforeChangeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(countBeforeChange BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCountBeforeChangeBuilder
	// WithCountBeforeChange adds CountBeforeChange (property field)
	WithCountBeforeChange(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCountBeforeChangeBuilder
	// WithCountBeforeChangeBuilder adds CountBeforeChange (property field) which is build by the builder
	WithCountBeforeChangeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataCountBeforeChangeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCountBeforeChange or returns an error if something is wrong
	Build() (BACnetConstructedDataCountBeforeChange, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCountBeforeChange
}

// NewBACnetConstructedDataCountBeforeChangeBuilder() creates a BACnetConstructedDataCountBeforeChangeBuilder
func NewBACnetConstructedDataCountBeforeChangeBuilder() BACnetConstructedDataCountBeforeChangeBuilder {
	return &_BACnetConstructedDataCountBeforeChangeBuilder{_BACnetConstructedDataCountBeforeChange: new(_BACnetConstructedDataCountBeforeChange)}
}

type _BACnetConstructedDataCountBeforeChangeBuilder struct {
	*_BACnetConstructedDataCountBeforeChange

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataCountBeforeChangeBuilder) = (*_BACnetConstructedDataCountBeforeChangeBuilder)(nil)

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCountBeforeChange
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) WithMandatoryFields(countBeforeChange BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCountBeforeChangeBuilder {
	return b.WithCountBeforeChange(countBeforeChange)
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) WithCountBeforeChange(countBeforeChange BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCountBeforeChangeBuilder {
	b.CountBeforeChange = countBeforeChange
	return b
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) WithCountBeforeChangeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataCountBeforeChangeBuilder {
	builder := builderSupplier(b.CountBeforeChange.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.CountBeforeChange, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) Build() (BACnetConstructedDataCountBeforeChange, error) {
	if b.CountBeforeChange == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'countBeforeChange' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataCountBeforeChange.deepCopy(), nil
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) MustBuild() BACnetConstructedDataCountBeforeChange {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCountBeforeChangeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCountBeforeChangeBuilder().(*_BACnetConstructedDataCountBeforeChangeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataCountBeforeChangeBuilder creates a BACnetConstructedDataCountBeforeChangeBuilder
func (b *_BACnetConstructedDataCountBeforeChange) CreateBACnetConstructedDataCountBeforeChangeBuilder() BACnetConstructedDataCountBeforeChangeBuilder {
	if b == nil {
		return NewBACnetConstructedDataCountBeforeChangeBuilder()
	}
	return &_BACnetConstructedDataCountBeforeChangeBuilder{_BACnetConstructedDataCountBeforeChange: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCountBeforeChange) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCountBeforeChange) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCountBeforeChange) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCountBeforeChange) GetCountBeforeChange() BACnetApplicationTagUnsignedInteger {
	return m.CountBeforeChange
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataCountBeforeChange) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetCountBeforeChange())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCountBeforeChange(structType any) BACnetConstructedDataCountBeforeChange {
	if casted, ok := structType.(BACnetConstructedDataCountBeforeChange); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCountBeforeChange); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCountBeforeChange) GetTypeName() string {
	return "BACnetConstructedDataCountBeforeChange"
}

func (m *_BACnetConstructedDataCountBeforeChange) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (countBeforeChange)
	lengthInBits += m.CountBeforeChange.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataCountBeforeChange) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCountBeforeChange) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCountBeforeChange BACnetConstructedDataCountBeforeChange, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCountBeforeChange"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCountBeforeChange")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	countBeforeChange, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "countBeforeChange", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'countBeforeChange' field"))
	}
	m.CountBeforeChange = countBeforeChange

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), countBeforeChange)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCountBeforeChange"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCountBeforeChange")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCountBeforeChange) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCountBeforeChange) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCountBeforeChange"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCountBeforeChange")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "countBeforeChange", m.GetCountBeforeChange(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'countBeforeChange' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCountBeforeChange"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCountBeforeChange")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCountBeforeChange) IsBACnetConstructedDataCountBeforeChange() {}

func (m *_BACnetConstructedDataCountBeforeChange) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCountBeforeChange) deepCopy() *_BACnetConstructedDataCountBeforeChange {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCountBeforeChangeCopy := &_BACnetConstructedDataCountBeforeChange{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.CountBeforeChange),
	}
	_BACnetConstructedDataCountBeforeChangeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCountBeforeChangeCopy
}

func (m *_BACnetConstructedDataCountBeforeChange) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
