/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TranslateBrowsePathsToNodeIdsRequest is the corresponding interface of TranslateBrowsePathsToNodeIdsRequest
type TranslateBrowsePathsToNodeIdsRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() RequestHeader
	// GetBrowsePaths returns BrowsePaths (property field)
	GetBrowsePaths() []BrowsePath
	// IsTranslateBrowsePathsToNodeIdsRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTranslateBrowsePathsToNodeIdsRequest()
	// CreateBuilder creates a TranslateBrowsePathsToNodeIdsRequestBuilder
	CreateTranslateBrowsePathsToNodeIdsRequestBuilder() TranslateBrowsePathsToNodeIdsRequestBuilder
}

// _TranslateBrowsePathsToNodeIdsRequest is the data-structure of this message
type _TranslateBrowsePathsToNodeIdsRequest struct {
	ExtensionObjectDefinitionContract
	RequestHeader RequestHeader
	BrowsePaths   []BrowsePath
}

var _ TranslateBrowsePathsToNodeIdsRequest = (*_TranslateBrowsePathsToNodeIdsRequest)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_TranslateBrowsePathsToNodeIdsRequest)(nil)

// NewTranslateBrowsePathsToNodeIdsRequest factory function for _TranslateBrowsePathsToNodeIdsRequest
func NewTranslateBrowsePathsToNodeIdsRequest(requestHeader RequestHeader, browsePaths []BrowsePath) *_TranslateBrowsePathsToNodeIdsRequest {
	if requestHeader == nil {
		panic("requestHeader of type RequestHeader for TranslateBrowsePathsToNodeIdsRequest must not be nil")
	}
	_result := &_TranslateBrowsePathsToNodeIdsRequest{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		RequestHeader:                     requestHeader,
		BrowsePaths:                       browsePaths,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TranslateBrowsePathsToNodeIdsRequestBuilder is a builder for TranslateBrowsePathsToNodeIdsRequest
type TranslateBrowsePathsToNodeIdsRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(requestHeader RequestHeader, browsePaths []BrowsePath) TranslateBrowsePathsToNodeIdsRequestBuilder
	// WithRequestHeader adds RequestHeader (property field)
	WithRequestHeader(RequestHeader) TranslateBrowsePathsToNodeIdsRequestBuilder
	// WithRequestHeaderBuilder adds RequestHeader (property field) which is build by the builder
	WithRequestHeaderBuilder(func(RequestHeaderBuilder) RequestHeaderBuilder) TranslateBrowsePathsToNodeIdsRequestBuilder
	// WithBrowsePaths adds BrowsePaths (property field)
	WithBrowsePaths(...BrowsePath) TranslateBrowsePathsToNodeIdsRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the TranslateBrowsePathsToNodeIdsRequest or returns an error if something is wrong
	Build() (TranslateBrowsePathsToNodeIdsRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TranslateBrowsePathsToNodeIdsRequest
}

// NewTranslateBrowsePathsToNodeIdsRequestBuilder() creates a TranslateBrowsePathsToNodeIdsRequestBuilder
func NewTranslateBrowsePathsToNodeIdsRequestBuilder() TranslateBrowsePathsToNodeIdsRequestBuilder {
	return &_TranslateBrowsePathsToNodeIdsRequestBuilder{_TranslateBrowsePathsToNodeIdsRequest: new(_TranslateBrowsePathsToNodeIdsRequest)}
}

type _TranslateBrowsePathsToNodeIdsRequestBuilder struct {
	*_TranslateBrowsePathsToNodeIdsRequest

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (TranslateBrowsePathsToNodeIdsRequestBuilder) = (*_TranslateBrowsePathsToNodeIdsRequestBuilder)(nil)

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._TranslateBrowsePathsToNodeIdsRequest
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) WithMandatoryFields(requestHeader RequestHeader, browsePaths []BrowsePath) TranslateBrowsePathsToNodeIdsRequestBuilder {
	return b.WithRequestHeader(requestHeader).WithBrowsePaths(browsePaths...)
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) WithRequestHeader(requestHeader RequestHeader) TranslateBrowsePathsToNodeIdsRequestBuilder {
	b.RequestHeader = requestHeader
	return b
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) WithRequestHeaderBuilder(builderSupplier func(RequestHeaderBuilder) RequestHeaderBuilder) TranslateBrowsePathsToNodeIdsRequestBuilder {
	builder := builderSupplier(b.RequestHeader.CreateRequestHeaderBuilder())
	var err error
	b.RequestHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "RequestHeaderBuilder failed"))
	}
	return b
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) WithBrowsePaths(browsePaths ...BrowsePath) TranslateBrowsePathsToNodeIdsRequestBuilder {
	b.BrowsePaths = browsePaths
	return b
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) Build() (TranslateBrowsePathsToNodeIdsRequest, error) {
	if b.RequestHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'requestHeader' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TranslateBrowsePathsToNodeIdsRequest.deepCopy(), nil
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) MustBuild() TranslateBrowsePathsToNodeIdsRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_TranslateBrowsePathsToNodeIdsRequestBuilder) DeepCopy() any {
	_copy := b.CreateTranslateBrowsePathsToNodeIdsRequestBuilder().(*_TranslateBrowsePathsToNodeIdsRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTranslateBrowsePathsToNodeIdsRequestBuilder creates a TranslateBrowsePathsToNodeIdsRequestBuilder
func (b *_TranslateBrowsePathsToNodeIdsRequest) CreateTranslateBrowsePathsToNodeIdsRequestBuilder() TranslateBrowsePathsToNodeIdsRequestBuilder {
	if b == nil {
		return NewTranslateBrowsePathsToNodeIdsRequestBuilder()
	}
	return &_TranslateBrowsePathsToNodeIdsRequestBuilder{_TranslateBrowsePathsToNodeIdsRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_TranslateBrowsePathsToNodeIdsRequest) GetExtensionId() int32 {
	return int32(554)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TranslateBrowsePathsToNodeIdsRequest) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TranslateBrowsePathsToNodeIdsRequest) GetRequestHeader() RequestHeader {
	return m.RequestHeader
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) GetBrowsePaths() []BrowsePath {
	return m.BrowsePaths
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastTranslateBrowsePathsToNodeIdsRequest(structType any) TranslateBrowsePathsToNodeIdsRequest {
	if casted, ok := structType.(TranslateBrowsePathsToNodeIdsRequest); ok {
		return casted
	}
	if casted, ok := structType.(*TranslateBrowsePathsToNodeIdsRequest); ok {
		return *casted
	}
	return nil
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) GetTypeName() string {
	return "TranslateBrowsePathsToNodeIdsRequest"
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Implicit Field (noOfBrowsePaths)
	lengthInBits += 32

	// Array field
	if len(m.BrowsePaths) > 0 {
		for _curItem, element := range m.BrowsePaths {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.BrowsePaths), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__translateBrowsePathsToNodeIdsRequest TranslateBrowsePathsToNodeIdsRequest, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TranslateBrowsePathsToNodeIdsRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TranslateBrowsePathsToNodeIdsRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	requestHeader, err := ReadSimpleField[RequestHeader](ctx, "requestHeader", ReadComplex[RequestHeader](ExtensionObjectDefinitionParseWithBufferProducer[RequestHeader]((int32)(int32(391))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestHeader' field"))
	}
	m.RequestHeader = requestHeader

	noOfBrowsePaths, err := ReadImplicitField[int32](ctx, "noOfBrowsePaths", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfBrowsePaths' field"))
	}
	_ = noOfBrowsePaths

	browsePaths, err := ReadCountArrayField[BrowsePath](ctx, "browsePaths", ReadComplex[BrowsePath](ExtensionObjectDefinitionParseWithBufferProducer[BrowsePath]((int32)(int32(545))), readBuffer), uint64(noOfBrowsePaths))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'browsePaths' field"))
	}
	m.BrowsePaths = browsePaths

	if closeErr := readBuffer.CloseContext("TranslateBrowsePathsToNodeIdsRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TranslateBrowsePathsToNodeIdsRequest")
	}

	return m, nil
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TranslateBrowsePathsToNodeIdsRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TranslateBrowsePathsToNodeIdsRequest")
		}

		if err := WriteSimpleField[RequestHeader](ctx, "requestHeader", m.GetRequestHeader(), WriteComplex[RequestHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestHeader' field")
		}
		noOfBrowsePaths := int32(utils.InlineIf(bool((m.GetBrowsePaths()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetBrowsePaths()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfBrowsePaths", noOfBrowsePaths, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfBrowsePaths' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "browsePaths", m.GetBrowsePaths(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'browsePaths' field")
		}

		if popErr := writeBuffer.PopContext("TranslateBrowsePathsToNodeIdsRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TranslateBrowsePathsToNodeIdsRequest")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) IsTranslateBrowsePathsToNodeIdsRequest() {}

func (m *_TranslateBrowsePathsToNodeIdsRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) deepCopy() *_TranslateBrowsePathsToNodeIdsRequest {
	if m == nil {
		return nil
	}
	_TranslateBrowsePathsToNodeIdsRequestCopy := &_TranslateBrowsePathsToNodeIdsRequest{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[RequestHeader](m.RequestHeader),
		utils.DeepCopySlice[BrowsePath, BrowsePath](m.BrowsePaths),
	}
	_TranslateBrowsePathsToNodeIdsRequestCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _TranslateBrowsePathsToNodeIdsRequestCopy
}

func (m *_TranslateBrowsePathsToNodeIdsRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
