/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetEventParameterOutOfRange extends BACnetEventParameter implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetOpeningTag openingTag;
  protected final BACnetContextTagUnsignedInteger timeDelay;
  protected final BACnetContextTagReal lowDiffLimit;
  protected final BACnetContextTagReal highDiffLimit;
  protected final BACnetContextTagReal deadband;
  protected final BACnetClosingTag closingTag;

  public BACnetEventParameterOutOfRange(
      BACnetTagHeader peekedTagHeader,
      BACnetOpeningTag openingTag,
      BACnetContextTagUnsignedInteger timeDelay,
      BACnetContextTagReal lowDiffLimit,
      BACnetContextTagReal highDiffLimit,
      BACnetContextTagReal deadband,
      BACnetClosingTag closingTag) {
    super(peekedTagHeader);
    this.openingTag = openingTag;
    this.timeDelay = timeDelay;
    this.lowDiffLimit = lowDiffLimit;
    this.highDiffLimit = highDiffLimit;
    this.deadband = deadband;
    this.closingTag = closingTag;
  }

  public BACnetOpeningTag getOpeningTag() {
    return openingTag;
  }

  public BACnetContextTagUnsignedInteger getTimeDelay() {
    return timeDelay;
  }

  public BACnetContextTagReal getLowDiffLimit() {
    return lowDiffLimit;
  }

  public BACnetContextTagReal getHighDiffLimit() {
    return highDiffLimit;
  }

  public BACnetContextTagReal getDeadband() {
    return deadband;
  }

  public BACnetClosingTag getClosingTag() {
    return closingTag;
  }

  @Override
  protected void serializeBACnetEventParameterChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetEventParameterOutOfRange");

    // Simple Field (openingTag)
    writeSimpleField("openingTag", openingTag, writeComplex(writeBuffer));

    // Simple Field (timeDelay)
    writeSimpleField("timeDelay", timeDelay, writeComplex(writeBuffer));

    // Simple Field (lowDiffLimit)
    writeSimpleField("lowDiffLimit", lowDiffLimit, writeComplex(writeBuffer));

    // Simple Field (highDiffLimit)
    writeSimpleField("highDiffLimit", highDiffLimit, writeComplex(writeBuffer));

    // Simple Field (deadband)
    writeSimpleField("deadband", deadband, writeComplex(writeBuffer));

    // Simple Field (closingTag)
    writeSimpleField("closingTag", closingTag, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetEventParameterOutOfRange");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetEventParameterOutOfRange _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (openingTag)
    lengthInBits += openingTag.getLengthInBits();

    // Simple field (timeDelay)
    lengthInBits += timeDelay.getLengthInBits();

    // Simple field (lowDiffLimit)
    lengthInBits += lowDiffLimit.getLengthInBits();

    // Simple field (highDiffLimit)
    lengthInBits += highDiffLimit.getLengthInBits();

    // Simple field (deadband)
    lengthInBits += deadband.getLengthInBits();

    // Simple field (closingTag)
    lengthInBits += closingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetEventParameterBuilder staticParseBACnetEventParameterBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetEventParameterOutOfRange");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag openingTag =
        readSimpleField(
            "openingTag",
            readComplex(() -> BACnetOpeningTag.staticParse(readBuffer, (short) (5)), readBuffer));

    BACnetContextTagUnsignedInteger timeDelay =
        readSimpleField(
            "timeDelay",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagReal lowDiffLimit =
        readSimpleField(
            "lowDiffLimit",
            readComplex(
                () ->
                    (BACnetContextTagReal)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.REAL)),
                readBuffer));

    BACnetContextTagReal highDiffLimit =
        readSimpleField(
            "highDiffLimit",
            readComplex(
                () ->
                    (BACnetContextTagReal)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (2), (BACnetDataType) (BACnetDataType.REAL)),
                readBuffer));

    BACnetContextTagReal deadband =
        readSimpleField(
            "deadband",
            readComplex(
                () ->
                    (BACnetContextTagReal)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (3), (BACnetDataType) (BACnetDataType.REAL)),
                readBuffer));

    BACnetClosingTag closingTag =
        readSimpleField(
            "closingTag",
            readComplex(() -> BACnetClosingTag.staticParse(readBuffer, (short) (5)), readBuffer));

    readBuffer.closeContext("BACnetEventParameterOutOfRange");
    // Create the instance
    return new BACnetEventParameterOutOfRangeBuilderImpl(
        openingTag, timeDelay, lowDiffLimit, highDiffLimit, deadband, closingTag);
  }

  public static class BACnetEventParameterOutOfRangeBuilderImpl
      implements BACnetEventParameter.BACnetEventParameterBuilder {
    private final BACnetOpeningTag openingTag;
    private final BACnetContextTagUnsignedInteger timeDelay;
    private final BACnetContextTagReal lowDiffLimit;
    private final BACnetContextTagReal highDiffLimit;
    private final BACnetContextTagReal deadband;
    private final BACnetClosingTag closingTag;

    public BACnetEventParameterOutOfRangeBuilderImpl(
        BACnetOpeningTag openingTag,
        BACnetContextTagUnsignedInteger timeDelay,
        BACnetContextTagReal lowDiffLimit,
        BACnetContextTagReal highDiffLimit,
        BACnetContextTagReal deadband,
        BACnetClosingTag closingTag) {
      this.openingTag = openingTag;
      this.timeDelay = timeDelay;
      this.lowDiffLimit = lowDiffLimit;
      this.highDiffLimit = highDiffLimit;
      this.deadband = deadband;
      this.closingTag = closingTag;
    }

    public BACnetEventParameterOutOfRange build(BACnetTagHeader peekedTagHeader) {
      BACnetEventParameterOutOfRange bACnetEventParameterOutOfRange =
          new BACnetEventParameterOutOfRange(
              peekedTagHeader,
              openingTag,
              timeDelay,
              lowDiffLimit,
              highDiffLimit,
              deadband,
              closingTag);
      return bACnetEventParameterOutOfRange;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetEventParameterOutOfRange)) {
      return false;
    }
    BACnetEventParameterOutOfRange that = (BACnetEventParameterOutOfRange) o;
    return (getOpeningTag() == that.getOpeningTag())
        && (getTimeDelay() == that.getTimeDelay())
        && (getLowDiffLimit() == that.getLowDiffLimit())
        && (getHighDiffLimit() == that.getHighDiffLimit())
        && (getDeadband() == that.getDeadband())
        && (getClosingTag() == that.getClosingTag())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getOpeningTag(),
        getTimeDelay(),
        getLowDiffLimit(),
        getHighDiffLimit(),
        getDeadband(),
        getClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
