/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NLMRejectMessageToNetwork extends NLM implements Message {

  // Accessors for discriminator values.
  public Short getMessageType() {
    return (short) 0x03;
  }

  // Properties.
  protected final NLMRejectMessageToNetworkRejectReason rejectReason;
  protected final int destinationNetworkAddress;

  // Arguments.
  protected final Integer apduLength;

  public NLMRejectMessageToNetwork(
      NLMRejectMessageToNetworkRejectReason rejectReason,
      int destinationNetworkAddress,
      Integer apduLength) {
    super(apduLength);
    this.rejectReason = rejectReason;
    this.destinationNetworkAddress = destinationNetworkAddress;
    this.apduLength = apduLength;
  }

  public NLMRejectMessageToNetworkRejectReason getRejectReason() {
    return rejectReason;
  }

  public int getDestinationNetworkAddress() {
    return destinationNetworkAddress;
  }

  @Override
  protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NLMRejectMessageToNetwork");

    // Simple Field (rejectReason)
    writeSimpleEnumField(
        "rejectReason",
        "NLMRejectMessageToNetworkRejectReason",
        rejectReason,
        writeEnum(
            NLMRejectMessageToNetworkRejectReason::getValue,
            NLMRejectMessageToNetworkRejectReason::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (destinationNetworkAddress)
    writeSimpleField(
        "destinationNetworkAddress", destinationNetworkAddress, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("NLMRejectMessageToNetwork");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NLMRejectMessageToNetwork _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (rejectReason)
    lengthInBits += 8;

    // Simple field (destinationNetworkAddress)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength)
      throws ParseException {
    readBuffer.pullContext("NLMRejectMessageToNetwork");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NLMRejectMessageToNetworkRejectReason rejectReason =
        readEnumField(
            "rejectReason",
            "NLMRejectMessageToNetworkRejectReason",
            readEnum(
                NLMRejectMessageToNetworkRejectReason::enumForValue,
                readUnsignedShort(readBuffer, 8)));

    int destinationNetworkAddress =
        readSimpleField("destinationNetworkAddress", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("NLMRejectMessageToNetwork");
    // Create the instance
    return new NLMRejectMessageToNetworkBuilderImpl(
        rejectReason, destinationNetworkAddress, apduLength);
  }

  public static class NLMRejectMessageToNetworkBuilderImpl implements NLM.NLMBuilder {
    private final NLMRejectMessageToNetworkRejectReason rejectReason;
    private final int destinationNetworkAddress;
    private final Integer apduLength;

    public NLMRejectMessageToNetworkBuilderImpl(
        NLMRejectMessageToNetworkRejectReason rejectReason,
        int destinationNetworkAddress,
        Integer apduLength) {
      this.rejectReason = rejectReason;
      this.destinationNetworkAddress = destinationNetworkAddress;
      this.apduLength = apduLength;
    }

    public NLMRejectMessageToNetwork build(Integer apduLength) {

      NLMRejectMessageToNetwork nLMRejectMessageToNetwork =
          new NLMRejectMessageToNetwork(rejectReason, destinationNetworkAddress, apduLength);
      return nLMRejectMessageToNetwork;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NLMRejectMessageToNetwork)) {
      return false;
    }
    NLMRejectMessageToNetwork that = (NLMRejectMessageToNetwork) o;
    return (getRejectReason() == that.getRejectReason())
        && (getDestinationNetworkAddress() == that.getDestinationNetworkAddress())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRejectReason(), getDestinationNetworkAddress());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
