/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LldpManagementAddressType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 18956;
  }

  // Properties.
  protected final long addressSubtype;
  protected final PascalString address;
  protected final ManAddrIfSubtype ifSubtype;
  protected final long ifId;

  public LldpManagementAddressType(
      long addressSubtype, PascalString address, ManAddrIfSubtype ifSubtype, long ifId) {
    super();
    this.addressSubtype = addressSubtype;
    this.address = address;
    this.ifSubtype = ifSubtype;
    this.ifId = ifId;
  }

  public long getAddressSubtype() {
    return addressSubtype;
  }

  public PascalString getAddress() {
    return address;
  }

  public ManAddrIfSubtype getIfSubtype() {
    return ifSubtype;
  }

  public long getIfId() {
    return ifId;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LldpManagementAddressType");

    // Simple Field (addressSubtype)
    writeSimpleField("addressSubtype", addressSubtype, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (address)
    writeSimpleField("address", address, writeComplex(writeBuffer));

    // Simple Field (ifSubtype)
    writeSimpleEnumField(
        "ifSubtype",
        "ManAddrIfSubtype",
        ifSubtype,
        writeEnum(
            ManAddrIfSubtype::getValue,
            ManAddrIfSubtype::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (ifId)
    writeSimpleField("ifId", ifId, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("LldpManagementAddressType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LldpManagementAddressType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (addressSubtype)
    lengthInBits += 32;

    // Simple field (address)
    lengthInBits += address.getLengthInBits();

    // Simple field (ifSubtype)
    lengthInBits += 32;

    // Simple field (ifId)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("LldpManagementAddressType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long addressSubtype = readSimpleField("addressSubtype", readUnsignedLong(readBuffer, 32));

    PascalString address =
        readSimpleField(
            "address", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    ManAddrIfSubtype ifSubtype =
        readEnumField(
            "ifSubtype",
            "ManAddrIfSubtype",
            readEnum(ManAddrIfSubtype::enumForValue, readUnsignedLong(readBuffer, 32)));

    long ifId = readSimpleField("ifId", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("LldpManagementAddressType");
    // Create the instance
    return new LldpManagementAddressTypeBuilderImpl(addressSubtype, address, ifSubtype, ifId);
  }

  public static class LldpManagementAddressTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long addressSubtype;
    private final PascalString address;
    private final ManAddrIfSubtype ifSubtype;
    private final long ifId;

    public LldpManagementAddressTypeBuilderImpl(
        long addressSubtype, PascalString address, ManAddrIfSubtype ifSubtype, long ifId) {
      this.addressSubtype = addressSubtype;
      this.address = address;
      this.ifSubtype = ifSubtype;
      this.ifId = ifId;
    }

    public LldpManagementAddressType build() {
      LldpManagementAddressType lldpManagementAddressType =
          new LldpManagementAddressType(addressSubtype, address, ifSubtype, ifId);
      return lldpManagementAddressType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LldpManagementAddressType)) {
      return false;
    }
    LldpManagementAddressType that = (LldpManagementAddressType) o;
    return (getAddressSubtype() == that.getAddressSubtype())
        && (getAddress() == that.getAddress())
        && (getIfSubtype() == that.getIfSubtype())
        && (getIfId() == that.getIfId())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getAddressSubtype(), getAddress(), getIfSubtype(), getIfId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
