/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The getNodeName() method of an Attribute node.
 * Retrieve the attribute named street from the last
 * child of of the second employee and examine its
 * NodeName.  This test uses the getNamedItem(name) method from the NamedNodeMap
 * interface.
 * Unlike the DOM 1 Core equivalent, this test can expect the
 * attribute name to be upper case for HTML documents.
 * * @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095</a>
 *
 * @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1112119403">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1112119403</a>
 * @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=236">http://www.w3.org/Bugs/Public/show_bug.cgi?id=236</a>
 * @see <a href="http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html">http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html</a>
 */
public class hc_attrname {
    @Test
    void testRun() throws Throwable {
        Document doc = load("hc_staff", false);
        NodeList addressList = doc.getElementsByTagName("acronym");
        Node testNode = addressList.item(1);
        NamedNodeMap attributes = testNode.getAttributes();
        Attr streetAttr = (Attr) attributes.getNamedItem("class");
        String strong1 = streetAttr.getNodeName();
        String strong2 = streetAttr.getName();
        assertEquals("class", strong1, "nodeName");
        assertEquals("class", strong2, "name");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/hc_attrname";
    }

}
