/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * AbstractTextLinesParserAdaptor
 * 
 * @version $Id: AbstractTextLinesParserAdaptor.java 821934 2009-10-05 17:50:07Z woonsan $
 */
public abstract class AbstractTextLinesParserAdaptor implements ParserAdaptor
{

    private static Logger log = LoggerFactory.getLogger(AbstractTextLinesParserAdaptor.class);
    
    public void rewrite(Rewriter rewriter, Reader reader, Writer writer) throws RewriterException
    {
        PrintWriter out = new PrintWriter(new BufferedWriter(writer));
        
        for (LineIterator lineIt = IOUtils.lineIterator(reader); lineIt.hasNext(); )
        {
            String line = lineIt.nextLine();
            
            if (!StringUtils.isBlank(line))
            {
                try 
                {
                    line = rewriteLine(line);
                }
                catch (Exception e)
                {
                    log.warn("Error during {}: {}", "replacement", e);
                }
            }
            
            out.println(line);
        }
        
        out.flush();
    }
    
    protected abstract String rewriteLine(String line) throws Exception;
    
    public void parse(Rewriter rewriter, Reader reader) throws RewriterException
    {
        throw new UnsupportedOperationException("Text lines parser adaptor does not support parse() method.");
    }
    
}
