/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibatis.jpetstore.persistence;

import com.ibatis.common.resources.Resources;
import com.ibatis.dao.client.DaoManager;
import com.ibatis.dao.client.DaoManagerBuilder;

import java.io.Reader;

/**
 * <p/>
 * Date: Mar 6, 2004 11:24:18 PM
 *
 * @author Clinton Begin
 */
public class DaoConfig {

  private static final DaoManager daoManager;

  static {

    try {
      String resource = "com/ibatis/jpetstore/persistence/dao.xml";
      Reader reader = Resources.getResourceAsReader(resource);
      daoManager = DaoManagerBuilder.buildDaoManager(reader);
    } catch (Exception e) {
      throw new RuntimeException("Could not initialize DaoConfig.  Cause: " + e);
    }
  }

  public static DaoManager getDaomanager() {
    return daoManager;
  }

}
