/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.frameworks.spring;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResults;
import org.apache.portals.bridges.frameworks.ExternalComponentSupport;
import org.apache.portals.bridges.frameworks.Lookup;
import org.apache.portals.bridges.frameworks.model.ModelBean;
import org.apache.portals.bridges.frameworks.model.PortletApplicationModel;
import org.apache.portals.bridges.frameworks.spring.ModelBeanImpl;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PortletApplicationModelImpl
implements PortletApplicationModel {
    private static final String PORTLET_VIEW_BEAN_MAP = "portlet-view-bean-map";
    private static final String PORTLET_VIEW_VALIDATOR_MAP = "portlet-view-validator-map";
    private static final String PORTLET_LOGICAL_VIEW_MAP = "portlet-views";
    private static final String PORTLET_ACTION_FORWARD_MAP = "portlet-action-forward-map";
    private XmlBeanFactory springFactory = null;
    private Map viewBeanMap = null;
    private ValidatorResources validations = null;
    private Map viewValidatorMap = null;
    private Map logicalViewMap = null;
    private Map actionForwardMap = null;
    private Map modelBeanMap = new HashMap();
    private Map externalSupportMap = new HashMap();
    private static Object semaphore = new Object();
    private String springConfig;
    private String validatorConfig = null;

    public PortletApplicationModelImpl(String springConfig, String validatorConfig) {
        this.springConfig = springConfig;
        this.validatorConfig = validatorConfig;
    }

    public void setExternalSupport(Map map) {
        this.externalSupportMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(PortletConfig config) throws PortletException {
        Object object;
        block26: {
            try {
                object = semaphore;
                synchronized (object) {
                    if (null == this.springFactory) {
                        this.springFactory = new XmlBeanFactory((Resource)new FileSystemResource(config.getPortletContext().getRealPath(this.springConfig)));
                    }
                }
            }
            catch (Exception e) {
                throw new PortletException("Failed to load spring configuration.", (Throwable)e);
            }
            object = semaphore;
            synchronized (object) {
                if (this.validatorConfig != null && null == this.validations) {
                    InputStream is = null;
                    try {
                        try {
                            is = config.getPortletContext().getResourceAsStream(this.validatorConfig);
                            this.validations = new ValidatorResources(is);
                        }
                        catch (Exception e) {
                            throw new PortletException("Failed to load validator configuration.", (Throwable)e);
                        }
                        Object var6_5 = null;
                        if (is == null) break block26;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (Exception e) {}
                    is.close();
                }
            }
        }
        object = semaphore;
        synchronized (object) {
            this.logicalViewMap = (Map)this.springFactory.getBean(PORTLET_LOGICAL_VIEW_MAP);
            if (this.logicalViewMap == null) {
                this.logicalViewMap = new HashMap();
            }
        }
        object = semaphore;
        synchronized (object) {
            this.viewValidatorMap = (Map)this.springFactory.getBean(PORTLET_VIEW_VALIDATOR_MAP);
            if (this.viewValidatorMap == null) {
                this.viewValidatorMap = new HashMap();
            }
        }
        object = semaphore;
        synchronized (object) {
            this.viewBeanMap = (Map)this.springFactory.getBean(PORTLET_VIEW_BEAN_MAP);
            if (this.viewBeanMap == null) {
                this.viewBeanMap = new HashMap();
            }
        }
        object = semaphore;
        synchronized (object) {
            this.actionForwardMap = (Map)this.springFactory.getBean(PORTLET_ACTION_FORWARD_MAP);
            if (this.actionForwardMap != null) return;
            this.actionForwardMap = new HashMap();
            return;
        }
    }

    public ModelBean getModelBean(String view) {
        ModelBean modelBean;
        String beanName = (String)this.viewBeanMap.get(view);
        if (beanName != null) {
            modelBean = (ModelBean)this.modelBeanMap.get(beanName);
            if (modelBean == null) {
                BeanDefinition bd = this.springFactory.getBeanDefinition(beanName);
                Object bean = this.springFactory.getBean(beanName);
                if (bd == null || bean == null) {
                    return new ModelBeanImpl(beanName, 0);
                }
                String lookup = null;
                boolean requiresExternalSupport = false;
                PropertyValue propValue = bd.getPropertyValues().getPropertyValue("lookupKey");
                if (propValue != null) {
                    Object value = propValue.getValue();
                    lookup = value instanceof TypedStringValue ? ((TypedStringValue)value).getValue() : (String)value;
                }
                if (bean instanceof ExternalComponentSupport) {
                    requiresExternalSupport = true;
                }
                modelBean = new ModelBeanImpl(beanName, 0, lookup, requiresExternalSupport);
                this.modelBeanMap.put(beanName, modelBean);
            }
        } else {
            modelBean = new ModelBeanImpl(beanName, 1);
        }
        return modelBean;
    }

    public String getTemplate(String view) {
        return (String)this.logicalViewMap.get(view);
    }

    public Object lookupBean(ModelBean mb, String key) {
        Object bean = this.springFactory.getBean(mb.getBeanName());
        if (bean != null) {
            if (mb.isRequiresExternalSupport()) {
                ExternalComponentSupport ecs = (ExternalComponentSupport)bean;
                ecs.setExternalSupport(this.externalSupportMap.get(mb.getBeanName()));
            }
            if (mb.isRequiresLookup()) {
                ((Lookup)bean).lookup(key);
            }
        }
        return bean;
    }

    public Object createBean(ModelBean mb) {
        Object bean = this.springFactory.getBean(mb.getBeanName());
        if (bean != null && mb.isRequiresExternalSupport()) {
            ExternalComponentSupport ecs = (ExternalComponentSupport)bean;
            ecs.setExternalSupport(this.externalSupportMap.get(mb.getBeanName()));
        }
        return bean;
    }

    public Map createPrefsBean(ModelBean mb, Map original) {
        HashMap prefs = new HashMap();
        Iterator it = original.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                prefs.put(key, value);
                continue;
            }
            if (!(value instanceof String[])) continue;
            prefs.put(key, ((String[])value)[0]);
        }
        return prefs;
    }

    public Map validate(Object bean, String view, ResourceBundle bundle) throws PortletException {
        HashMap result = new HashMap();
        if (this.validations == null) {
            return result;
        }
        String validatorFormName = (String)this.viewValidatorMap.get(view);
        if (validatorFormName == null) {
            return result;
        }
        Validator validator = new Validator(this.validations, validatorFormName);
        validator.setParameter("java.lang.Object", bean);
        validator.setParameter("java.util.Map", result);
        validator.setParameter("java.util.ResourceBundle", (Object)bundle);
        ValidatorResults results = null;
        try {
            validator.setOnlyReturnErrors(true);
            results = validator.validate();
            if (results.isEmpty()) {
                return result;
            }
        }
        catch (ValidatorException e) {
            throw new PortletException("Error in processing validation: ", (Throwable)e);
        }
        return result;
    }

    public String getForward(String view, String status) {
        return (String)this.actionForwardMap.get(view + ":" + status);
    }

    public String getForward(String view) {
        return (String)this.actionForwardMap.get(view);
    }
}

