/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.php;

import com.itgroundwork.portlet.php.servlet;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.common.ScriptPostProcess;
import org.apache.portals.bridges.common.ServletContextProvider;
import org.apache.portals.bridges.php.PHPParameters;
import org.apache.portals.bridges.php.ServletConfigImpl;

public class PHPApplicationPortlet
extends GenericPortlet {
    public static final String PARAM_SERVLET_CONTEXT_PROVIDER = "ServletContextProvider";
    public static final String START_PAGE = "StartPage";
    private ServletContextProvider servletContextProvider;
    private static final Log log = LogFactory.getLog((Class)PHPApplicationPortlet.class);
    ServletConfigImpl servletConfig = null;
    servlet phpServletImpl = null;
    private String startPage = null;
    private boolean bUseCachedParameters = false;
    private String lastContextPath = null;
    private String lastQuery = null;
    private String lastURI = null;
    private String portletID = null;

    public void init(PortletConfig config) throws PortletException {
        block7: {
            super.init(config);
            this.startPage = config.getInitParameter(START_PAGE);
            String contextProviderClassName = config.getInitParameter(PARAM_SERVLET_CONTEXT_PROVIDER);
            if (this.startPage == null) {
                throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + START_PAGE + " not specified");
            }
            if (contextProviderClassName == null) {
                throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + PARAM_SERVLET_CONTEXT_PROVIDER + " not specified");
            }
            if (contextProviderClassName != null) {
                try {
                    Object obj;
                    Class<?> clazz = Class.forName(contextProviderClassName);
                    if (clazz == null) break block7;
                    if (ServletContextProvider.class.isInstance(obj = clazz.newInstance())) {
                        this.servletContextProvider = (ServletContextProvider)obj;
                        break block7;
                    }
                    throw new PortletException("class not found");
                }
                catch (Exception e) {
                    if (e instanceof PortletException) {
                        throw (PortletException)e;
                    }
                    e.printStackTrace();
                    throw new PortletException("Cannot load", (Throwable)e);
                }
            }
        }
        this.servletConfig = new ServletConfigImpl(config, this.servletContextProvider.getServletContext((GenericPortlet)this));
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String phpParameter = actionRequest.getParameter("_PHP");
        if (phpParameter != null && phpParameter.length() > 0) {
            PHPParameters phpScript = new PHPParameters();
            int ixQuery = phpParameter.indexOf(63);
            if (ixQuery != -1) {
                phpScript.setScriptName(phpParameter.substring(0, ixQuery));
                String queryArguments = phpParameter.substring(ixQuery + 1);
                System.out.println("ProcessRequest -- Script " + phpParameter.substring(0, ixQuery) + " Query string " + queryArguments);
                int ixQuerySeparator = queryArguments.indexOf(38);
                while (ixQuerySeparator != -1) {
                    phpScript.addQueryArgument(queryArguments.substring(0, ixQuerySeparator));
                    queryArguments = queryArguments.substring(ixQuerySeparator + 1);
                    ixQuerySeparator = queryArguments.indexOf(38);
                }
                phpScript.addQueryArgument(queryArguments);
                actionRequest.getPortletSession().setAttribute("PHPParameter", (Object)phpScript, 1);
            } else {
                phpScript.setScriptName(phpParameter);
                Enumeration names = actionRequest.getParameterNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (name.compareToIgnoreCase("_PHP") == 0) continue;
                    String value = actionRequest.getParameter(name);
                    phpScript.addQueryArgument(name + "=" + value);
                }
                actionRequest.getPortletSession().setAttribute("PHPParameter", (Object)phpScript, 1);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String runContext;
        String runQuery;
        String runURI;
        String phpScript;
        String reqQuery;
        PHPParameters phpParam = null;
        try {
            phpParam = (PHPParameters)((Object)request.getPortletSession().getAttribute("PHPParameter", 1));
        }
        catch (Exception e) {
            phpParam = null;
        }
        if (phpParam != null) {
            this.bUseCachedParameters = false;
            reqQuery = phpParam.getQueryString();
            phpScript = phpParam.getScriptName();
        } else {
            this.bUseCachedParameters = true;
            reqQuery = "";
            phpScript = this.startPage;
        }
        HttpServletRequest httpRequest = this.servletContextProvider.getHttpServletRequest((GenericPortlet)this, (PortletRequest)request);
        HttpServletResponse httpResponse = this.servletContextProvider.getHttpServletResponse((GenericPortlet)this, (PortletResponse)response);
        if (this.phpServletImpl == null) {
            try {
                this.phpServletImpl = new servlet();
                if (this.phpServletImpl != null) {
                    this.phpServletImpl.init((ServletConfig)this.servletConfig);
                }
            }
            catch (ServletException se) {
                httpResponse.getWriter().println("<p><b>Initializationof PHP servlet failed!</b> Error: " + se.getMessage() + "</p>");
            }
        }
        String userName = "anon";
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            userName = userPrincipal.getName();
        }
        boolean bShowInfoPage = false;
        Object cookieValue = null;
        String contextPath = request.getContextPath();
        PortletContext portletApplication = this.getPortletContext();
        String path = portletApplication.getRealPath("/WEB-INF");
        String rootContextPath = path + "/";
        if (this.bUseCachedParameters) {
            if (this.lastURI == null || this.lastURI.length() == 0) {
                this.lastURI = contextPath + "/" + phpScript;
                this.lastContextPath = rootContextPath + phpScript;
            }
            runURI = this.lastURI;
            runQuery = this.lastQuery;
            runContext = this.lastContextPath;
        } else {
            String adjURI = contextPath + "/" + phpScript;
            String phpContext = rootContextPath + phpScript;
            runURI = adjURI;
            runQuery = reqQuery;
            runContext = phpContext;
        }
        try {
            if (this.phpServletImpl != null) {
                if (runQuery == null) {
                    runQuery = "";
                }
                this.phpServletImpl.setUseInternalPage();
                this.phpServletImpl.setAdjustedURI(runURI);
                this.phpServletImpl.setAuthenticatedUser(userName);
                this.phpServletImpl.setAdjustedQuery(runQuery);
                this.phpServletImpl.service(httpRequest, httpResponse, runContext);
                this.lastQuery = runQuery;
                this.lastContextPath = runContext;
                this.lastURI = runURI;
                PortletURL actionURL = response.createActionURL();
                StringBuffer page = this.phpServletImpl.getSourcePage();
                ScriptPostProcess processor = new ScriptPostProcess();
                processor.setInitalPage(page);
                processor.postProcessPage(actionURL, "_PHP");
                String finalPage = processor.getFinalizedPage();
                httpResponse.getWriter().println(finalPage);
            } else {
                httpResponse.getWriter().println("<br/><b>Error in PHP servlet. Couldn't create instance of com.itgroundwork.portlet.php.servlet. Make sure the jar is included in the same app as the portas-bridges-php jar file</b>");
            }
        }
        catch (ServletException se) {
            httpResponse.getWriter().println("<P><B>Error in PHP servlet.Servlet Exception: " + se.getMessage() + "</B>RunQuery=" + runQuery + " RunContext=" + runContext + " RunURI=" + runURI + " </P><BR>");
            throw new PortletException((Throwable)se);
        }
        catch (IOException e) {
            httpResponse.getWriter().println("<P><B>Error in PHP servlet. IO Exception " + e.getMessage() + "</B>RunQuery=" + runQuery + " RunContext=" + runContext + "Run URI=" + runURI + "</P><BR>");
        }
    }
}

