/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyPreferencesValidator
implements PreferencesValidator {
    public static final String SCRIPT_SOURCE_PREF_KEY = "validator-script-source";
    public static final String SCRIPT_SOURCE_URL_ENCODING_PREF_KEY = "validator-script-source-uri-encoding";
    public static final String AUTO_REFRESH_PREF_KEY = "validator-auto-refresh";
    protected String scriptSourceUri;
    protected String scriptSourceUriEncoding = "UTF-8";
    protected boolean autoRefresh;
    protected long parsedFileLastModified;
    protected GroovyCodeSource groovyCodeSource;
    protected PreferencesValidator scriptPreferencesValidatorInstance;
    protected GroovyClassLoader groovyClassLoader;

    public void validate(PortletPreferences preferences) throws ValidatorException {
        if (this.groovyCodeSource == null) {
            this.initialize(preferences);
        }
        this.refreshPreferencesValidatorInstance();
        this.scriptPreferencesValidatorInstance.validate(preferences);
    }

    public void initialize(PortletPreferences preferences) throws ValidatorException {
        block11: {
            this.groovyClassLoader = new GroovyClassLoader();
            this.autoRefresh = "true".equals(preferences.getValue(AUTO_REFRESH_PREF_KEY, null));
            String param = preferences.getValue(SCRIPT_SOURCE_URL_ENCODING_PREF_KEY, null);
            if (param != null) {
                this.scriptSourceUriEncoding = param;
            }
            this.scriptSourceUri = preferences.getValue(SCRIPT_SOURCE_PREF_KEY, null);
            if (this.scriptSourceUri == null) {
                ArrayList<String> failedKeys = new ArrayList<String>();
                failedKeys.add(SCRIPT_SOURCE_PREF_KEY);
                throw new ValidatorException("Configuration failed: validator-script-source should be set properly!", failedKeys);
            }
            try {
                if (this.scriptSourceUri.startsWith("file:")) {
                    String decodedScriptSourceUri = this.scriptSourceUri;
                    try {
                        decodedScriptSourceUri = URLDecoder.decode(this.scriptSourceUri, this.scriptSourceUriEncoding);
                    }
                    catch (UnsupportedEncodingException encodingEx) {
                        ArrayList<String> failedKeys = new ArrayList<String>();
                        failedKeys.add(SCRIPT_SOURCE_URL_ENCODING_PREF_KEY);
                        throw new ValidatorException("Unsupported encoding: " + this.scriptSourceUriEncoding, failedKeys);
                    }
                    this.groovyCodeSource = new GroovyCodeSource(new File(decodedScriptSourceUri.substring(5)));
                    break block11;
                }
                if (this.scriptSourceUri.startsWith("classpath:")) {
                    String resourceURL = this.groovyClassLoader.getResource(this.scriptSourceUri.substring(10)).toString();
                    if (resourceURL.startsWith("file:")) {
                        String decodedScriptSourceUri = resourceURL;
                        try {
                            decodedScriptSourceUri = URLDecoder.decode(resourceURL, this.scriptSourceUriEncoding);
                        }
                        catch (UnsupportedEncodingException encodingEx) {
                            ArrayList<String> failedKeys = new ArrayList<String>();
                            failedKeys.add(SCRIPT_SOURCE_URL_ENCODING_PREF_KEY);
                            throw new ValidatorException("Unsupported encoding: " + this.scriptSourceUriEncoding, failedKeys);
                        }
                        this.groovyCodeSource = new GroovyCodeSource(new File(decodedScriptSourceUri.substring(5)));
                        break block11;
                    }
                    ArrayList<String> failedKeys = new ArrayList<String>();
                    failedKeys.add(SCRIPT_SOURCE_PREF_KEY);
                    throw new ValidatorException("validator-script-source with 'classpath:' prefix should indicate to a local resource", failedKeys);
                }
                ArrayList<String> failedKeys = new ArrayList<String>();
                failedKeys.add(SCRIPT_SOURCE_PREF_KEY);
                throw new ValidatorException("Configuration failed: validator-script-source should be prefixed by 'file:' or 'classpath'.", failedKeys);
            }
            catch (FileNotFoundException e) {
                ArrayList<String> failedKeys = new ArrayList<String>();
                failedKeys.add(SCRIPT_SOURCE_PREF_KEY);
                throw new ValidatorException("File not found: " + this.scriptSourceUri, failedKeys);
            }
        }
        this.groovyCodeSource.setCachable(!this.autoRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPreferencesValidatorInstance() throws ValidatorException {
        if (this.scriptPreferencesValidatorInstance == null) {
            try {
                this.createScriptPreferencesValidatorInstance();
            }
            catch (Exception ex) {
                ArrayList<String> failedKeys = new ArrayList<String>();
                failedKeys.add(SCRIPT_SOURCE_PREF_KEY);
                throw new ValidatorException("Could not compile script: " + this.scriptSourceUri, failedKeys);
            }
        }
        if (this.autoRefresh && this.isScriptFileModified()) {
            PreferencesValidator preferencesValidator = this.scriptPreferencesValidatorInstance;
            synchronized (preferencesValidator) {
                try {
                    this.createScriptPreferencesValidatorInstance();
                }
                catch (Exception ex) {
                    ArrayList<String> failedKeys = new ArrayList<String>();
                    failedKeys.add(SCRIPT_SOURCE_PREF_KEY);
                    throw new ValidatorException("Could not compile script: " + this.scriptSourceUri, failedKeys);
                }
            }
        }
    }

    protected boolean isScriptFileModified() {
        return this.groovyCodeSource.getFile().lastModified() > this.parsedFileLastModified;
    }

    protected void createScriptPreferencesValidatorInstance() throws CompilationFailedException, InstantiationException, IOException, IllegalAccessException, ValidatorException {
        Class scriptPreferencesValidatorClass = this.groovyClassLoader.parseClass(this.groovyCodeSource);
        this.scriptPreferencesValidatorInstance = (PreferencesValidator)scriptPreferencesValidatorClass.newInstance();
        this.parsedFileLastModified = this.groovyCodeSource.getFile().lastModified();
    }
}

