/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.bridges.script;

import javax.portlet.GenericPortlet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

/**
 * @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
 * @version $Id$
 */
public class HelloGroovy extends GenericPortlet
{
    public void doView(RenderRequest request, RenderResponse response)
    {
        String greeting = "<H1>" + getTitle(request) + "</H1>";
        response.getWriter().println(greeting);
    }
    
    public void processAction(ActionRequest request, ActionResponse response)
    {
        request.getPreferences().setValue("message", request.getParameter("message"));
        request.getPreferences().store();
    }
    
    public void processEvent(EventRequest request, EventResponse response)
    {
        request.getAttribute("values").put("message", "hello");
    }
    
    public void serveResource(ResourceRequest request, ResourceResponse response)
    {
        request.getAttribute("values").put("message", "hello");
    }
}

// Return portlet instance as a last evaluated object
// because ScriptPortlet expects the evaluated result object as a portlet class or non-initialized portlet instance.
new HelloGroovy();
